\name{gelf_criteria_follicular_lymphoma}
\alias{gelf_criteria_follicular_lymphoma}
\title{
GELF Criteria for Follicular Lymphoma
}
\description{
Evaluates the Groupe d'Etude des Lymphomes Folliculaires (GELF) criteria to determine tumor burden in patients with follicular lymphoma. The presence of at least one criterion indicates high tumor burden, suggesting the need to initiate therapy rather than a "watch and wait" approach.
}
\usage{
gelf_criteria_follicular_lymphoma(nodal_mass_gt_7cm, multiple_nodal_sites_gt_3cm,
                                  systemic_symptoms, spleen_enlargement,
                                  organ_compression, pleural_ascitic_effusion,
                                  ldh_or_beta2_elevated)
}
\arguments{
  \item{nodal_mass_gt_7cm}{
Numeric (0 or 1). Presence of a nodal mass > 7 cm. (1 = Yes).
}
  \item{multiple_nodal_sites_gt_3cm}{
Numeric (0 or 1). Involvement of >= 3 nodal sites, each > 3 cm. (1 = Yes).
}
  \item{systemic_symptoms}{
Numeric (0 or 1). Presence of systemic symptoms (B symptoms: fever, night sweats, weight loss >10\%). (1 = Yes).
}
  \item{spleen_enlargement}{
Numeric (0 or 1). Symptomatic splenic enlargement (splenomegaly). (1 = Yes).
}
  \item{organ_compression}{
Numeric (0 or 1). Compression of a vital organ (e.g., ureteral obstruction, SVC syndrome). (1 = Yes).
}
  \item{pleural_ascitic_effusion}{
Numeric (0 or 1). Presence of pleural effusion or ascites. (1 = Yes).
}
  \item{ldh_or_beta2_elevated}{
Numeric (0 or 1). Elevated serum LDH or Beta-2 Microglobulin levels. (1 = Yes).
}
}
\value{
A list containing:
\item{GELF_Result}{"High Tumor Burden" if >= 1 criterion is met, otherwise "Low Tumor Burden".}
\item{Criteria_Count}{Total number of positive criteria.}
\item{Recommendation}{Clinical guidance regarding treatment initiation.}
}
\references{
Brice P, Bastion Y, Lepage E, et al. Comparison in low-tumor-burden follicular lymphomas between an initial no-treatment policy, prednimustine, or interferon alfa: a randomized study from the Groupe d'Etude des Lymphomes Folliculaires. Groupe d'Etude des Lymphomes Folliculaires. J Clin Oncol. 1997;15(3):1110-1117. doi:10.1200/JCO.1997.15.3.1110
}
\examples{

# Example 1: High Burden (Need Treatment)
# Large mass > 7cm, No other symptoms
gelf_criteria_follicular_lymphoma(1, 0, 0, 0, 0, 0, 0)

# Example 2: Low Burden (Watch and Wait)
# No criteria met
gelf_criteria_follicular_lymphoma(0, 0, 0, 0, 0, 0, 0)
}
