\name{framingham_hard_chd}
\alias{framingham_hard_chd}
\title{
Framingham Risk Score for Hard Coronary Heart Disease
}
\description{
Calculates the 10-year risk of developing hard coronary heart disease (myocardial infarction or coronary death). This score is derived from the NCEP ATP III guidelines.
}
\usage{
framingham_hard_chd(age, sex, smoker, total_cholesterol, hdl_cholesterol,
                    systolic_bp, bp_medication)
}
\arguments{
  \item{age}{
Numeric. Patient age in years (20-79).
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{smoker}{
Numeric (0 or 1). Current smoker. (1 = Yes).
}
  \item{total_cholesterol}{
Numeric. Total Cholesterol level in mg/dL.
}
  \item{hdl_cholesterol}{
Numeric. HDL Cholesterol level in mg/dL.
}
  \item{systolic_bp}{
Numeric. Systolic Blood Pressure in mmHg.
}
  \item{bp_medication}{
Numeric (0 or 1). Is the patient currently on medication for high blood pressure? (1 = Yes).
}
}
\value{
A list containing:
\item{Total_Points}{The calculated risk score.}
\item{Ten_Year_Risk_Hard_CHD}{The estimated percentage risk of MI or coronary death in the next 10 years.}
}
\references{
Expert Panel on Detection, Evaluation, and Treatment of High Blood Cholesterol in Adults. Executive Summary of The Third Report of The National Cholesterol Education Program (NCEP) Expert Panel on Detection, Evaluation, And Treatment of High Blood Cholesterol in Adults (Adult Treatment Panel III). JAMA. 2001;285(19):2486-2497. doi:10.1001/jama.285.19.2486
}
\examples{

# Example 1: Low Risk
# 45yo Male, Non-smoker, Chol 180, HDL 50, SBP 120 (No Meds)
framingham_hard_chd(45, "male", 0, 180, 50, 120, 0)

# Example 2: High Risk
# 65yo Female, Smoker, Chol 240, HDL 35, SBP 150 (Meds)
framingham_hard_chd(65, "female", 1, 240, 35, 150, 1)
}
