\name{four_score}
\alias{four_score}
\title{
Full Outline of UnResponsiveness (FOUR) Score
}
\description{
Calculates the FOUR Score, a neurological grading scale designed to assess patients with impaired consciousness. Unlike the Glasgow Coma Scale (GCS), the FOUR Score includes assessment of brainstem reflexes and respiration patterns, making it more suitable for intubated patients.
}
\usage{
four_score(eye_response, motor_response, brainstem_reflexes, respiration_pattern)
}
\arguments{
  \item{eye_response}{
Numeric (0-4).
4: Eyelids open or opened, tracking, or blinking to command.
3: Eyelids open but not tracking.
2: Eyelids closed but open to loud voice.
1: Eyelids closed but open to pain.
0: Eyelids remain closed with pain.
}
  \item{motor_response}{
Numeric (0-4).
4: Thumbs-up, fist, or peace sign.
3: Localizing to pain.
2: Flexion response to pain.
1: Extension response to pain.
0: No response to pain or generalized myoclonus status.
}
  \item{brainstem_reflexes}{
Numeric (0-4).
4: Pupil and corneal reflexes present.
3: One pupil wide and fixed.
2: Pupil or corneal reflexes absent.
1: Pupil and corneal reflexes absent.
0: Absent pupil, corneal, and cough reflex.
}
  \item{respiration_pattern}{
Numeric (0-4).
4: Not intubated, regular breathing pattern.
3: Not intubated, Cheyne-Stokes breathing pattern.
2: Not intubated, irregular breathing.
1: Breathes above ventilator rate.
0: Breathes at ventilator rate or apnea.
}
}
\value{
A list containing:
\item{FOUR_Score}{The calculated total score (Range 0-16).}
\item{Interpretation}{Prognostic guidance based on the score (Lower scores indicate higher mortality).}
}
\references{
Wijdicks EF, Bamlet WR, Maramattom BV, Manno EM, McClelland RL. Validation of a new coma scale: The FOUR score. Ann Neurol. 2005;58(4):585-593. doi:10.1002/ana.20611
}
\examples{

# Example 1: Comatose/Intubated (High Severity)
# Eyes closed to pain (0), Extension (1), Absent reflexes (0), Vent rate (0)
# Score = 1
four_score(0, 1, 0, 0)

# Example 2: Conscious
# Tracking (4), Thumbs up (4), Reflexes intact (4), Regular breath (4)
# Score = 16
four_score(4, 4, 4, 4)
}
