\name{flipi_score}
\alias{flipi_score}
\title{
Follicular Lymphoma International Prognostic Index (FLIPI)
}
\description{
Calculates the FLIPI score to predict overall survival in patients with follicular lymphoma. The score uses five adverse prognostic factors: Age >= 60, Ann Arbor Stage III-IV, Hemoglobin < 12 g/dL, Elevated LDH, and > 4 Nodal sites involved.
}
\usage{
flipi_score(age, ann_arbor_stage, hemoglobin_g_dl, ldh_elevated,
            num_nodal_sites)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 60 years adds +1 point).
}
  \item{ann_arbor_stage}{
Numeric (1-4). Ann Arbor Stage. (Stage III or IV adds +1 point).
}
  \item{hemoglobin_g_dl}{
Numeric. Hemoglobin level in g/dL. (< 12 g/dL adds +1 point).
}
  \item{ldh_elevated}{
Numeric (0 or 1). Serum LDH greater than the upper limit of normal. (1 = Yes, +1 point).
}
  \item{num_nodal_sites}{
Numeric. Count of involved nodal areas. (> 4 sites adds +1 point).
}
}
\value{
A list containing:
\item{FLIPI_Score}{The calculated score (Range 0-5).}
\item{Risk_Group}{Classification (Low 0-1, Intermediate 2, High >=3).}
\item{Est_10_Year_Survival}{Estimated 10-year overall survival percentage.}
}
\references{
Solal-Céligny P, Roy P, Colombat P, et al. Follicular lymphoma international prognostic index. Blood. 2004;104(5):1258-1265. doi:10.1182/blood-2003-12-4434
}
\examples{

# Example 1: High Risk
# 65yo (+1), Stage IV (+1), Hb 11 (+1), Normal LDH (0), 3 Nodes (0)
# Score = 3
flipi_score(65, 4, 11.0, 0, 3)

# Example 2: Low Risk
# 50yo (0), Stage II (0), Hb 13 (0), High LDH (+1), 2 Nodes (0)
# Score = 1
flipi_score(50, 2, 13.0, 1, 2)
}
