\name{flacc_pain_score}
\alias{flacc_pain_score}
\title{
FLACC Behavioral Pain Assessment Scale
}
\description{
Calculates the FLACC score, a behavioral pain assessment scale used for children between the ages of 2 months and 7 years or individuals unable to communicate their pain. It evaluates five categories: Face, Legs, Activity, Cry, and Consolability. Each category is scored from 0 to 2, resulting in a total score between 0 and 10.
}
\usage{
flacc_pain_score(face, legs, activity, cry, consolability)
}
\arguments{
  \item{face}{
Numeric (0-2).
0: No particular expression or smile.
1: Occasional grimace or frown, withdrawn, disinterested.
2: Frequent to constant quivering chin, clenched jaw.
}
  \item{legs}{
Numeric (0-2).
0: Normal position or relaxed.
1: Uneasy, restless, tense.
2: Kicking, or legs drawn up.
}
  \item{activity}{
Numeric (0-2).
0: Lying quietly, normal position, moves easily.
1: Squirming, shifting back and forth, tense.
2: Arched, rigid, or jerking.
}
  \item{cry}{
Numeric (0-2).
0: No cry (awake or asleep).
1: Moans or whimpers; occasional complaint.
2: Crying steadily, screams or sobs, frequent complaints.
}
  \item{consolability}{
Numeric (0-2).
0: Content, relaxed.
1: Reassured by occasional touching, hugging, or being talked to; distractible.
2: Difficult to console or comfort.
}
}
\value{
A list containing:
\item{FLACC_Score}{The calculated total score (Range 0-10).}
\item{Interpretation}{Clinical interpretation of pain severity (Relaxed, Mild, Moderate, Severe).}
}
\references{
Merkel SI, Voepel-Lewis T, Shayevitz JR, Malviya S. The FLACC: a behavioral scale for scoring postoperative pain in young children. Pediatr Nurs. 1997;23(3):293-297.
}
\examples{

# Example 1: Severe Pain
# Grimacing(2), Kicking(2), Arched(2), Screaming(2), Difficult to console(2)
flacc_pain_score(2, 2, 2, 2, 2)

# Example 2: Mild Discomfort
# Frown(1), Normal legs(0), Squirming(1), No cry(0), Distractible(1)
# Score = 3
flacc_pain_score(1, 0, 1, 0, 1)
}
