\name{estimate_toxic_alcohol_level}
\alias{estimate_toxic_alcohol_level}
\title{
Estimated Serum Concentration for Toxic Alcohols
}
\description{
Calculates the theoretical peak serum concentration of Ethanol, Methanol, Ethylene Glycol, or Isopropanol following an acute ingestion. The estimation uses the Widmark formula variant: \deqn{Cp = \frac{Volume \times Concentration \times SpecificGravity}{Weight \times Vd}} where Cp is the peak concentration.
}
\usage{
estimate_toxic_alcohol_level(substance, volume_ingested, volume_units,
                             concentration_percent, weight_kg, sex = "male")
}
\arguments{
  \item{substance}{
String. The ingested substance. Options: "ethanol", "methanol", "ethylene_glycol", "isopropanol".
}
  \item{volume_ingested}{
Numeric. The volume of liquid ingested.
}
  \item{volume_units}{
String. Units of volume. Options: "mL", "oz", "L".
}
  \item{concentration_percent}{
Numeric. The concentration of the substance in percent (e.g., 40 for 80-proof vodka, 95 for antifreeze).
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). Primarily affects the Volume of Distribution (Vd) used for Ethanol calculations.
}
}
\value{
A list containing:
\item{Estimated_Peak_Concentration_mg_dL}{The calculated peak serum level in mg/dL.}
\item{Interpretation}{Clinical context regarding toxic thresholds (e.g., treatment indication for methanol/ethylene glycol at >20 mg/dL).}
}
\references{
Widmark EMP. Principles and Applications of Medicolegal Alcohol Determination. Biomedical Publications. 1981. (Original derivation).
Goldfrank's Toxicologic Emergencies. (Standard toxicology reference for Vd and SG values).
}
\examples{

# Example 1: Methanol Ingestion
# 100 mL of 100\% Methanol, 70kg person
estimate_toxic_alcohol_level("methanol", 100, "mL", 100, 70)

# Example 2: Ethanol Intoxication
# 500 mL of 40\% Vodka, 80kg Male
# SG ~0.79, Vd ~0.7
estimate_toxic_alcohol_level("ethanol", 500, "mL", 40, 80, "male")
}
