\name{doac_bleeding_risk}
\alias{doac_bleeding_risk}
\title{
DOAC Score for Bleeding Risk
}
\description{
Calculates the DOAC Score to estimate the risk of major bleeding in patients with atrial fibrillation taking Direct Oral Anticoagulants (DOACs). This score was derived specifically for DOAC users, distinguishing it from HAS-BLED which was derived for Warfarin.
}
\usage{
doac_bleeding_risk(age, criteria_count_gt_1, creatinine_clearance_ml_min,
                   prior_bleeding, hypertension, nsaids_antiplatelets,
                   cirrhosis_history, history_stroke, prior_major_bleeding,
                   extreme_body_weight)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (65-74: +1 pt; >=75: +2 pts).
}
  \item{criteria_count_gt_1}{
Numeric (0 or 1). Does the patient meet criteria for having >1 comorbid condition (e.g., diabetes, stroke, etc.)? (1 = Yes, +2 pts). (Note: This input simplifies a complex comorbidity count often used in the original derivation).
}
  \item{creatinine_clearance_ml_min}{
Numeric. Creatinine Clearance (CrCl). (< 60 mL/min adds +1 pt).
}
  \item{prior_bleeding}{
Numeric (0 or 1). History of any prior bleeding event (minor or major). (1 = Yes, +2 pts).
}
  \item{hypertension}{
Numeric (0 or 1). History of Hypertension. (1 = Yes, +1 pt).
}
  \item{nsaids_antiplatelets}{
Numeric (0 or 1). Concomitant use of NSAIDs or Antiplatelets. (1 = Yes, +1 pt).
}
  \item{cirrhosis_history}{
Numeric (0 or 1). History of Liver Cirrhosis. (1 = Yes, +1 pt).
}
  \item{history_stroke}{
Numeric (0 or 1). History of Stroke/TIA. (1 = Yes, +1 pt).
}
  \item{prior_major_bleeding}{
Numeric (0 or 1). History of Major Bleeding specifically. (1 = Yes, +1 pt).
}
  \item{extreme_body_weight}{
Numeric (0 or 1). Extreme body weight (<50kg or >100kg). (1 = Yes, +1 pt).
}
}
\value{
A list containing:
\item{DOAC_Score}{The calculated risk score.}
\item{Risk_Category}{Classification (Low <=3, Moderate 4-7, High >=8).}
}
\references{
Kozieł-Siołkowska M, et al. A Novel Bleeding Risk Score for Patients with Atrial Fibrillation on Direct Oral Anticoagulants (The DOAC Score). Cardiology. 2018.
}
\examples{

# Example 1: Moderate Risk
# Age 70 (+1), CrCl 50 (+1), HTN (+1), NSAIDs (+1)
# Score = 4
doac_bleeding_risk(70, 0, 50, 0, 1, 1, 0, 0, 0, 0)

# Example 2: High Risk
# Age 80 (+2), Prior Bleed (+2), Major Bleed (+1), Stroke (+1), Wt<50 (+1), CrCl 40 (+1)
# Score = 8
doac_bleeding_risk(80, 0, 40, 1, 0, 0, 0, 1, 1, 1)
}
