\name{caprini_vte_score}
\alias{caprini_vte_score}
\title{
Caprini Score for Venous Thromboembolism (2005)
}
\description{
Calculates the 2005 Caprini Risk Score to stratify surgical patients for risk of Venous Thromboembolism (VTE). The score aggregates weighted risk factors to determine the appropriate level of prophylaxis (mechanical vs. pharmacological).
}
\usage{
caprini_vte_score(age, risk_factors_1pt_count, risk_factors_2pt_count,
                  risk_factors_3pt_count, risk_factors_5pt_count)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{risk_factors_1pt_count}{
Numeric. Count of 1-point risk factors present (excluding Age).
Includes: Minor surgery, BMI > 25, Swollen legs, Varicose veins, Pregnancy/Postpartum, History of unexplained abortion, Oral contraceptives/HRT, Sepsis <1mo, Serious lung disease <1mo, Abnormal pulmonary function, Acute MI, CHF <1mo, Medical patient on bed rest, History of IBD, Prior major surgery <1mo.
}
  \item{risk_factors_2pt_count}{
Numeric. Count of 2-point risk factors present (excluding Age).
Includes: Major open surgery (>45 min), Laparoscopic surgery (>45 min), Arthroscopic surgery, Malignancy (present or past), Confined to bed >72h, Immobilizing cast <1mo, Central venous access.
}
  \item{risk_factors_3pt_count}{
Numeric. Count of 3-point risk factors present (excluding Age).
Includes: History of DVT/PE, Family history of thrombosis, Factor V Leiden, Prothrombin 20210A, Elevated serum homocysteine, Positive lupus anticoagulant, Elevated anticardiolipin antibodies, HIT, Other thrombophilia.
}
  \item{risk_factors_5pt_count}{
Numeric. Count of 5-point risk factors present.
Includes: Elective major lower extremity arthroplasty, Hip/Pelvis/Leg fracture <1mo, Stroke <1mo, Multiple trauma <1mo, Acute spinal cord injury <1mo.
}
}
\value{
A list containing:
\item{Caprini_Score}{The calculated total score.}
\item{Risk_Category}{Risk classification (Very Low, Low, Moderate, High).}
\item{Recommendation}{Suggested prophylaxis strategy.}
}
\references{
Caprini JA. Thrombosis risk assessment as a guide to quality patient care. Dis Mon. 2005;51(2-3):70-78. doi:10.1016/j.disamonth.2005.02.003
}
\examples{

# Example 1: Moderate Risk
# Age 50 (1 pt), BMI > 25 (1 pt), Laparoscopic surgery > 45min (2 pts)
# Score = 1 + 1 + 2 = 4
caprini_vte_score(50, 1, 1, 0, 0)

# Example 2: High Risk
# Age 76 (3 pts), Hip Fracture (5 pts)
# Score = 3 + 5 = 8
caprini_vte_score(76, 0, 0, 0, 1)
}
