\name{canrisk_diabetes_score}
\alias{canrisk_diabetes_score}
\title{
Canadian Diabetes Risk Assessment Questionnaire (CANRISK)
}
\description{
Calculates the CANRISK score to estimate the 10-year risk of developing Type 2 Diabetes or Pre-diabetes. Designed by the Public Health Agency of Canada, this tool adapts the FINDRISC model to the Canadian population by adding ethnicity and education level as risk factors.
}
\usage{
canrisk_diabetes_score(age, sex, bmi, waist_cm, physical_activity_daily,
                       fruit_veg_daily, hypertension_meds, high_glucose_history,
                       gave_birth_large_baby, family_history, ethnicity_risk,
                       education_level)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<45: 0 pts.
45-54: 7 pts.
55-64: 13 pts.
65-74: 15 pts.
}
  \item{sex}{
String. "male" or "female". (Male adds +6 points).
}
  \item{bmi}{
Numeric. Body Mass Index (kg/m^2).
<25: 0 pts.
25-29.9: 4 pts.
30-34.9: 9 pts.
>=35: 14 pts.
}
  \item{waist_cm}{
Numeric. Waist circumference in cm.
Male: 94-102 (+4), >102 (+6).
Female: 80-88 (+4), >88 (+6).
}
  \item{physical_activity_daily}{
Numeric (0 or 1). Do you usually do physical activity for 30 mins daily? (1 = Yes, 0 = No). Note: No adds +2 points.
}
  \item{fruit_veg_daily}{
Numeric (0 or 1). Do you eat vegetables or fruits every day? (1 = Yes, 0 = No). Note: No adds +2 points.
}
  \item{hypertension_meds}{
Numeric (0 or 1). Have you ever taken medication for high blood pressure? (1 = Yes, +2 pts).
}
  \item{high_glucose_history}{
Numeric (0 or 1). Have you ever been found to have high blood sugar? (1 = Yes, +14 pts).
}
  \item{gave_birth_large_baby}{
Numeric (0 or 1). (Females only) Have you given birth to a baby weighing 9 lbs (4.1 kg) or more? (1 = Yes, +1 pt).
}
  \item{family_history}{
String. "none" (0 pts), "other_relative" (Grandparent, Aunt, Uncle, Cousin: +2 pts), "parent_sibling" (Parent, Brother, Sister, Child: +4 pts).
}
  \item{ethnicity_risk}{
String. "white" (0 pts), "high" (Aboriginal, African, South Asian, Hispanic: +11 pts), "east_asian" (+10 pts), "other_non_white" (+3 pts).
}
  \item{education_level}{
String. "university" (0 pts), "secondary" (High school diploma: +1 pt), "primary" or "less_than_high_school" (Some high school or less: +5 pts).
}
}
\value{
A list containing:
\item{CANRISK_Score}{The calculated risk score (Range 0-~90).}
\item{Risk_Category}{Risk classification (Low <21, Moderate 21-32, High >=33).}
}
\references{
Public Health Agency of Canada. The Canadian Diabetes Risk Questionnaire (CANRISK).
Robinson CA, Agarwal G, Nylen K. Defining the risk of type 2 diabetes in the Canadian population: validation of the CANRISK.
}
\examples{

# Example 1: Low Risk
# 40yo Female, Normal BMI/Waist, Active, Healthy Diet, White, University
canrisk_diabetes_score(40, "female", 22, 70, 1, 1, 0, 0, 0, "none", "white", "university")

# Example 2: High Risk
# 55yo Male (+13+6), BMI 31 (+9), Waist 105 (+6), No Activity (+2),
#Parent DM (+4), High Risk Eth (+11)
# Score = 13+6+9+6+2+4+11 = 51
canrisk_diabetes_score(55, "male", 31, 105, 0, 1, 0, 0, 0, "parent_sibling", "high", "university")
}
