\name{calculate_serum_osmolality}
\alias{calculate_serum_osmolality}
\title{
Serum Osmolality/Osmolarity Calculator
}
\description{
Calculates the estimated serum osmolality (or osmolarity) based on serum sodium, glucose, and blood urea nitrogen (BUN). Optionally includes ethanol concentration if ingestion is suspected. This calculation is useful for determining the osmolal gap when compared to measured osmolality.
}
\usage{
calculate_serum_osmolality(sodium, glucose, bun, ethanol = 0,
                           glucose_units = "mg/dL", bun_units = "mg/dL",
                           ethanol_units = "mg/dL")
}
\arguments{
  \item{sodium}{
Numeric. Serum Sodium level in mEq/L or mmol/L.
}
  \item{glucose}{
Numeric. Serum Glucose level.
}
  \item{bun}{
Numeric. Blood Urea Nitrogen level.
}
  \item{ethanol}{
Numeric (Optional). Serum Ethanol level. Defaults to 0.
}
  \item{glucose_units}{
String. Units for glucose input. Options: "mg/dL" (default) or "mmol/L".
}
  \item{bun_units}{
String. Units for BUN input. Options: "mg/dL" (default) or "mmol/L".
}
  \item{ethanol_units}{
String. Units for ethanol input. Options: "mg/dL" (default) or "mmol/L".
}
}
\details{
The formula used (for mg/dL inputs) is:
\deqn{Osmolality = (2 \times Na) + \frac{Glucose}{18} + \frac{BUN}{2.8} + \frac{Ethanol}{4.6}}
If inputs are in mmol/L, the terms are simply summed (Ethanol factor may vary slightly in different literature but 4.6 divisor for mg/dL is standard).
}
\value{
A list containing:
\item{Calculated_Osmolality}{The estimated serum osmolality in mOsm/kg H2O.}
}
\references{
Purssell RA, Pudek M, Brubacher J, Abu-Laban RB. Derivation and validation of a formula to calculate the contribution of ethanol to the osmolal gap. Ann Emerg Med. 2001;38(6):653-659. doi:10.1067/mem.2001.119455
}
\examples{

# Example 1: Standard Labs (mg/dL)
# Na 140, Glucose 100, BUN 15, No Ethanol
# Calc = 280 + 5.5 + 5.4 = 290.9
calculate_serum_osmolality(140, 100, 15)

# Example 2: Ethanol Intoxication
# Na 135, Glucose 90, BUN 10, Ethanol 100 mg/dL
# Calc = 270 + 5 + 3.6 + 21.7 = 300.3
calculate_serum_osmolality(135, 90, 10, 100)
}
