\name{calculate_qtc}
\alias{calculate_qtc}
\title{
Corrected QT Interval (QTc) Calculator
}
\description{
Calculates the Corrected QT Interval (QTc) using four standard formulas: Bazett, Fridericia, Framingham, and Hodges. The QTc adjusts the measured QT interval for heart rate, allowing for the assessment of repolarization abnormalities (e.g., Long QT Syndrome) regardless of the patient's pulse.
}
\usage{
calculate_qtc(qt_interval_msec, heart_rate_bpm)
}
\arguments{
  \item{qt_interval_msec}{
Numeric. The measured QT interval in milliseconds (from the beginning of the Q wave to the end of the T wave).
}
  \item{heart_rate_bpm}{
Numeric. The patient's heart rate in beats per minute.
}
}
\details{
\strong{Formulas used:}
\itemize{
  \item Bazett: \eqn{QTc = QT / \sqrt{RR}} (Most common, but overcorrects at high heart rates).
  \item Fridericia: \eqn{QTc = QT / \sqrt[3]{RR}}.
  \item Framingham: \eqn{QTc = QT + 154 \times (1 - RR)}.
  \item Hodges: \eqn{QTc = QT + 1.75 \times (HR - 60)}.
}
Where \eqn{RR = 60 / HR}.
}
\value{
A list containing:
\item{QTc_Bazett}{QTc calculated via Bazett's formula.}
\item{QTc_Fridericia}{QTc calculated via Fridericia's formula.}
\item{QTc_Framingham}{QTc calculated via Framingham's formula.}
\item{QTc_Hodges}{QTc calculated via Hodges' formula.}
}
\references{
Bazett HC. An analysis of the time-relations of electrocardiograms. Heart. 1920;7:353-370.
Fridericia LS. Die Systolendauer im Elektrokardiogramm bei normalen Menschen und bei Herzkranken. Acta Medica Scandinavica. 1920;53:469-486.
}
\examples{

# Example 1: Normal Heart Rate
# QT 400 ms, HR 60 bpm (RR = 1 sec)
# All formulas should yield approx 400 ms
calculate_qtc(400, 60)

# Example 2: Tachycardia
# QT 320 ms, HR 100 bpm
# Bazett overcorrects compared to others
calculate_qtc(320, 100)
}
