\name{bristol_stool_scale}
\alias{bristol_stool_scale}
\title{
Bristol Stool Form Scale
}
\description{
Retrieves the description and clinical interpretation for the Bristol Stool Form Scale (BSFS). This diagnostic medical tool classifies the form of human faeces into seven categories, which correlate with colonic transit time.
}
\usage{
bristol_stool_scale(stool_type)
}
\arguments{
  \item{stool_type}{
Numeric (1-7). The integer corresponding to the visual appearance of the stool.
1: Separate hard lumps (nuts).
2: Sausage-shaped but lumpy.
3: Sausage-shaped with cracks.
4: Sausage/snake, smooth and soft.
5: Soft blobs with clear-cut edges.
6: Fluffy pieces with ragged edges.
7: Watery, no solid pieces.
}
}
\value{
A list containing:
\item{Type}{The input type number.}
\item{Description}{The textual description of the stool form.}
\item{Interpretation}{Clinical classification (e.g., Constipation, Normal, Diarrhea).}
\item{Est_Transit_Time}{General correlation with gut transit time.}
}
\references{
Lewis SJ, Heaton KW. Stool form scale as a useful guide to intestinal transit time. Scand J Gastroenterol. 1997;32(9):920-924. doi:10.3109/00365529709011203
}
\examples{

# Example 1: Normal Stool
bristol_stool_scale(4)

# Example 2: Severe Constipation
bristol_stool_scale(1)

# Example 3: Diarrhea
bristol_stool_scale(7)
}
