\name{basic_stats_calculator}
\alias{basic_stats_calculator}
\title{
Basic Statistics Calculator (Diagnostic Test Evaluation)
}
\description{
Calculates standard diagnostic statistics from a 2x2 contingency table (True Positives, False Positives, False Negatives, True Negatives). Metrics include Sensitivity, Specificity, Positive/Negative Predictive Values (PPV/NPV), Likelihood Ratios (LR+/LR-), Accuracy, and Disease Prevalence.
}
\usage{
basic_stats_calculator(tp, fp, fn, tn)
}
\arguments{
  \item{tp}{
Numeric. Count of True Positives (Disease Present, Test Positive).
}
  \item{fp}{
Numeric. Count of False Positives (Disease Absent, Test Positive).
}
  \item{fn}{
Numeric. Count of False Negatives (Disease Present, Test Negative).
}
  \item{tn}{
Numeric. Count of True Negatives (Disease Absent, Test Negative).
}
}
\value{
A list containing:
\item{Diagnostic_Accuracy}{Sensitivity, Specificity, and Overall Accuracy.}
\item{Predictive_Values}{PPV and NPV.}
\item{Likelihood_Ratios}{LR+ (Sensitivity / (1-Specificity)) and LR- ((1-Sensitivity) / Specificity).}
\item{Population_Stats}{Prevalence of disease in the sample and total sample size.}
}
\references{
Altman DG, Bland JM. Diagnostic tests 1: Sensitivity and specificity. BMJ. 1994;308(6943):1552.
Altman DG, Bland JM. Diagnostic tests 2: Predictive values. BMJ. 1994;309(6947):102.
}
\examples{

# Example 1: Good Test
# TP=80, FP=10, FN=20, TN=90
basic_stats_calculator(80, 10, 20, 90)

# Example 2: Perfect Specificity
# TP=50, FP=0, FN=50, TN=100
# LR+ will be Inf
basic_stats_calculator(50, 0, 50, 100)
}
