\name{basal_energy_expenditure}
\alias{basal_energy_expenditure}
\title{
Basal Energy Expenditure (Harris-Benedict Equation)
}
\description{
Calculates the Basal Energy Expenditure (BEE), which estimates the number of calories a person burns at rest over 24 hours. This function uses the original Harris-Benedict Equation (1919), which is widely used for nutritional assessments.
}
\usage{
basal_energy_expenditure(sex, height_cm, weight_kg, age)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{height_cm}{
Numeric. Patient height in centimeters.
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{age}{
Numeric. Patient age in years.
}
}
\value{
A list containing:
\item{BEE_kcal_day}{The estimated daily caloric needs at rest.}
\item{Formula}{Specification of the equation used (Harris-Benedict 1919).}
}
\references{
Harris JA, Benedict FG. A Biometric Study of Basal Metabolism in Man. Washington DC: Carnegie Institute of Washington. 1919.
}
\examples{

# Example 1: Male
# 180cm, 80kg, 30 years old
# BEE = 66.5 + (13.75*80) + (5.003*180) - (6.755*30) = 66.5 + 1100 + 900.5 - 202.6 = ~1864
basal_energy_expenditure("male", 180, 80, 30)

# Example 2: Female
# 160cm, 60kg, 40 years old
# BEE = 655.1 + (9.56*60) + (1.85*160) - (4.68*40) = 655.1 + 573.6 + 296 - 187.2 = ~1338
basal_energy_expenditure("female", 160, 60, 40)
}
