\name{asymptomatic_myeloma_prognosis}
\alias{asymptomatic_myeloma_prognosis}
\title{
Mayo Clinic Risk Stratification for Smoldering Multiple Myeloma (20-2-20 Model)
}
\description{
Calculates the risk stratification for patients with Smoldering Multiple Myeloma (SMM) using the "20-2-20" criteria developed by the Mayo Clinic. This model predicts the risk of progression to active Multiple Myeloma (MM) based on three risk factors: Bone Marrow Plasma Cells (BMPC) > 20\%, Serum M-protein > 2 g/dL, and Serum Free Light Chain (FLC) ratio > 20.
}
\usage{
asymptomatic_myeloma_prognosis(bmpc_percent, m_protein_g_dl, flc_ratio)
}
\arguments{
  \item{bmpc_percent}{
Numeric. Bone marrow plasma cells in percentage. (Threshold: > 20\%).
}
  \item{m_protein_g_dl}{
Numeric. Serum M-protein level in g/dL. (Threshold: > 2 g/dL).
}
  \item{flc_ratio}{
Numeric. Serum Free Light Chain ratio (involved : uninvolved). (Threshold: > 20).
}
}
\value{
A list containing:
\item{Total_Risk_Factors}{The count of risk factors present (0, 1, 2, or 3).}
\item{Risk_Group}{Classification (Low, Intermediate, or High Risk).}
\item{Median_Time_to_Progression}{Estimated median time to progression to active myeloma.}
\item{Progression_Risk_2yr}{Estimated probability of progression within 2 years.}
}
\references{
Lakshman A, Rajkumar SV, Buadi FK, et al. Risk stratification of smoldering multiple myeloma incorporating revised IMWG diagnostic criteria. Blood Cancer J. 2018;8(6):59. doi:10.1038/s41408-018-0077-4
}
\examples{

# Example 1: High Risk (2 factors)
# BMPC 30\%, M-protein 1.5, FLC Ratio 25
asymptomatic_myeloma_prognosis(30, 1.5, 25)

# Example 2: Low Risk (0 factors)
# BMPC 10\%, M-protein 1.0, FLC Ratio 8
asymptomatic_myeloma_prognosis(10, 1.0, 8)
}
