\name{antivenom_dosing_algorithm}
\alias{antivenom_dosing_algorithm}
\title{
Antivenom Dosing Algorithm (CroFab)
}
\description{
Determines the recommended dosing for CroFab antivenom in patients with North American Crotalid (pit viper) envenomation. The algorithm guides the initial dose to achieve control of symptoms (arrest of local progression, normalization of coagulopathy, and resolution of systemic signs) and subsequent maintenance therapy.
}
\usage{
antivenom_dosing_algorithm(signs_of_envenomation, initial_control_achieved = FALSE)
}
\arguments{
  \item{signs_of_envenomation}{
Numeric (0 or 1). Presence of signs of envenomation (swelling, tenderness, ecchymosis, coagulopathy, or systemic signs). (1 = Yes, 0 = No).
}
  \item{initial_control_achieved}{
Numeric (0 or 1). Has initial control been achieved? defined as the arrest of local progression, improvement in systemic signs, and stabilization of coagulation labs. (1 = Yes, 0 = No).
}
}
\value{
A list containing:
\item{Recommendation}{Guidance on initial or repeat dosing.}
\item{Maintenance_Therapy}{Instructions for maintenance doses if control is achieved.}
}
\references{
Lavonas EJ, Ruha AM, Banner W, et al. Unified treatment algorithm for the management of crotaline snakebite in the United States: results of an evidence-informed consensus workshop. BMC Emerg Med. 2011;11:2. doi:10.1186/1471-227X-11-2
}
\examples{

# Example 1: Initial Presentation
# Patient with swelling and pain
antivenom_dosing_algorithm(1, 0)

# Example 2: Control Achieved
# Patient received initial dose, swelling stopped, labs stable
antivenom_dosing_algorithm(1, 1)

# Example 3: Dry Bite
# No signs of envenomation
antivenom_dosing_algorithm(0, 0)
}
