\name{alberta_stroke_aspects}
\alias{alberta_stroke_aspects}
\title{
Alberta Stroke Program Early CT Score (ASPECTS)
}
\description{
Calculates the ASPECTS score to quantitate the severity of early ischemic changes on non-contrast CT scans in patients with acute ischemic stroke of the anterior circulation. The score starts at 10 and 1 point is subtracted for every region showing early ischemic changes. Lower scores indicate larger infarct volumes and poorer outcomes.
}
\usage{
alberta_stroke_aspects(caudate, lentiform, internal_capsule, insular_cortex,
                       m1, m2, m3, m4, m5, m6)
}
\arguments{
  \item{caudate}{
Numeric (0 or 1). Early ischemic change in the Caudate nucleus? (1 = Yes, 0 = No).
}
  \item{lentiform}{
Numeric (0 or 1). Early ischemic change in the Lentiform nucleus? (1 = Yes, 0 = No).
}
  \item{internal_capsule}{
Numeric (0 or 1). Early ischemic change in the Internal Capsule? (1 = Yes, 0 = No).
}
  \item{insular_cortex}{
Numeric (0 or 1). Early ischemic change in the Insular Cortex? (1 = Yes, 0 = No).
}
  \item{m1}{
Numeric (0 or 1). Early ischemic change in the "M1" region (Anterior MCA cortex)? (1 = Yes, 0 = No).
}
  \item{m2}{
Numeric (0 or 1). Early ischemic change in the "M2" region (MCA cortex lateral to insular ribbon)? (1 = Yes, 0 = No).
}
  \item{m3}{
Numeric (0 or 1). Early ischemic change in the "M3" region (Posterior MCA cortex)? (1 = Yes, 0 = No).
}
  \item{m4}{
Numeric (0 or 1). Early ischemic change in the "M4" region (Anterior MCA territory superior to M1)? (1 = Yes, 0 = No).
}
  \item{m5}{
Numeric (0 or 1). Early ischemic change in the "M5" region (Lateral MCA territory superior to M2)? (1 = Yes, 0 = No).
}
  \item{m6}{
Numeric (0 or 1). Early ischemic change in the "M6" region (Posterior MCA territory superior to M3)? (1 = Yes, 0 = No).
}
}
\value{
A list containing:
\item{ASPECTS_Value}{The final score (Range 0-10).}
\item{Interpretation}{Prognostic grouping based on the score (e.g., Score < 8 correlates with poor outcome).}
}
\references{
Barber PA, Demchuk AM, Zhang J, Buchan AM. Validity and reliability of a quantitative computed tomography score in predicting outcome of hyperacute stroke before thrombolytic therapy. ASPECTS Study Group. Alberta Stroke Programme Early CT Score. Lancet. 2000;355(9216):1670-1674. doi:10.1016/s0140-6736(00)02237-6
}
\examples{

# Example 1: Large Infarct (Score 6)
# Caudate, Lentiform, IC, and Insula involved
alberta_stroke_aspects(1, 1, 1, 1, 0, 0, 0, 0, 0, 0)

# Example 2: Normal CT (Score 10)
# No ischemic changes
alberta_stroke_aspects(0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
}
