\name{abic_alcoholic_hepatitis}
\alias{abic_alcoholic_hepatitis}
\title{
ABIC Score for Alcoholic Hepatitis
}
\description{
Calculates the ABIC (Age, Bilirubin, INR, Creatinine) Score to stratify the risk of death at 90 days in patients with alcoholic hepatitis. It categorizes patients into Low, Intermediate, and High risk groups, helping to guide treatment decisions such as the use of corticosteroids.
}
\usage{
abic_alcoholic_hepatitis(age, bilirubin, inr, creatinine,
                         bilirubin_units = "mg/dL", creatinine_units = "mg/dL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{bilirubin}{
Numeric. Serum bilirubin level.
}
  \item{inr}{
Numeric. International Normalized Ratio.
}
  \item{creatinine}{
Numeric. Serum creatinine level.
}
  \item{bilirubin_units}{
String. Units for bilirubin. Options: "mg/dL" (default) or "umol/L".
}
  \item{creatinine_units}{
String. Units for creatinine. Options: "mg/dL" (default) or "umol/L".
}
}
\value{
A list containing:
\item{ABIC_Score}{The calculated score.}
\item{Risk_Group}{Risk classification (Low, Intermediate, High).}
\item{Est_90_Day_Survival}{Estimated survival rate at 90 days based on the validation cohort.}
}
\references{
Dominguez M, Rincon D, Abraldes JG, et al. A new scoring system for prognostic stratification of patients with alcoholic hepatitis. Am J Gastroenterol. 2008;103(11):2747-2756. doi:10.1111/j.1572-0241.2008.02104.x
}
\examples{

# Example 1: High Risk
# 50yo, Bili 15 mg/dL, INR 2.0, Cr 1.5 mg/dL
# Score = (50*0.1) + (15*0.08) + (1.5*0.3) + (2.0*0.8) = 5 + 1.2 + 0.45 + 1.6 = 8.25 (Intermediate)
abic_alcoholic_hepatitis(50, 15, 2.0, 1.5)

# Example 2: Low Risk
# 40yo, Bili 3 mg/dL, INR 1.1, Cr 0.8 mg/dL
abic_alcoholic_hepatitis(40, 3, 1.1, 0.8)
}
