\name{abbey_pain_scale}
\alias{abbey_pain_scale}
\title{
Abbey Pain Scale for Dementia Patients
}
\description{
Calculates the Abbey Pain Scale score, a tool designed to assess pain in patients with advanced dementia who cannot verbalize their needs. The scale evaluates six domains: Vocalization, Facial Expression, Body Language, Behavioral Change, Physiological Change, and Physical Changes.
}
\usage{
abbey_pain_scale(vocalization, facial_expression, body_language,
                 behavioral_change, physiological_change, physical_changes)
}
\arguments{
  \item{vocalization}{
Numeric (0-3). Whimpering, groaning, crying. (0=Absent, 1=Mild, 2=Moderate, 3=Severe).
}
  \item{facial_expression}{
Numeric (0-3). Looking tense, frowning, grimacing, frightened. (0=Absent, 1=Mild, 2=Moderate, 3=Severe).
}
  \item{body_language}{
Numeric (0-3). Fidgeting, rocking, guarding body part, withdrawn. (0=Absent, 1=Mild, 2=Moderate, 3=Severe).
}
  \item{behavioral_change}{
Numeric (0-3). Increased confusion, refusing to eat, alteration in usual patterns. (0=Absent, 1=Mild, 2=Moderate, 3=Severe).
}
  \item{physiological_change}{
Numeric (0-3). Temperature/pulse/BP changes, perspiration, flushing/pallor. (0=Absent, 1=Mild, 2=Moderate, 3=Severe).
}
  \item{physical_changes}{
Numeric (0-3). Skin tears, pressure areas, arthritis, contractures, previous injuries. (0=Absent, 1=Mild, 2=Moderate, 3=Severe).
}
}
\value{
A list containing:
\item{Total_Score}{Sum of the 6 domain scores (Range 0-18).}
\item{Pain_Category}{Interpretation of pain severity (No pain, Mild, Moderate, Severe).}
\item{Management_Recommendation}{General guidance on intervention necessity.}
}
\references{
Abbey J, Piller N, De Bellis A, et al. The Abbey pain scale: a 1-minute numerical indicator for people with end-stage dementia. Int J Palliat Nurs. 2004;10(1):6-13. doi:10.12968/ijpn.2004.10.1.12013
}
\examples{

# Example 1: Moderate Pain
# Mild vocalization (1), Moderate facial expression (2), Mild body language (1),
# No behavioral change (0), Mild physiological change (1), Severe physical change (3)
# Total = 8
abbey_pain_scale(1, 2, 1, 0, 1, 3)

# Example 2: No Pain
# All absent
abbey_pain_scale(0, 0, 0, 0, 0, 0)
}
