% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{garden_club_sensitive}
\alias{garden_club_sensitive}
\title{Fictional "Garden Club" Data for MID Sensitivity Analysis}
\format{
A tibble with 200 rows and 3 variables:
\describe{
\item{id}{An integer representing the unique participant identifier.}
\item{time}{A numeric value for the measurement occasion (\code{1} = pre, \code{2} = post).}
\item{gei_score}{A numeric value for the outcome, the score on the fictional Gardener Envy Inventory (GEI).}
}
}
\source{
Simulated data where the mean change score is precisely calibrated to fall
within a range of plausible Minimal Important Difference (MID) values.
}
\usage{
garden_club_sensitive
}
\description{
A simulated dataset specifically designed to be "sensitive" to the choice
of a Minimal Important Difference (MID). The mean change score is
deliberately set to be near common MID thresholds, with a small standard
deviation, making it perfect for demonstrating MID-based sensitivity analyses.
}
\seealso{
\code{\link{garden_club}} for a more standard pre-post dataset.
}
\keyword{datasets}
