\name{dot-class}
\docType{class}
\alias{dot}
\alias{.}
\alias{dot-class}
\alias{commutator}
\alias{jacobi}
\alias{dot_error}
\alias{[.dot}
\alias{[,dot-method}
\alias{[,dot,ANY,ANY-method}
\alias{[,dot,ANY,missing-method}
\alias{[,dot,missing,ANY-method}
\alias{[,dot,missing,missing-method}
\alias{[,dot,matrix,matrix-method}
\alias{[,dot,clifford,ANY,ANY-method}
\alias{[,dot,clifford,ANY-method}
\title{Class \dQuote{dot}}
\description{

  The dot object is defined so that idiom like \code{.[x,y]} returns the
  commutator, that is, \code{(x*y-y*x)/2}.  The factor of 2 ensures that
  \code{.[x,y] == x \%X\% y}.

  The dot object is generated by running script \code{inst/dot.Rmd},
  which includes some further discussion and technical documentation,
  and creates file \code{dot.rda} which resides in the \code{data/}
  directory.

}
\arguments{
  \item{x}{Object of any class}
  \item{i, j}{elements to commute}
  \item{...}{Further arguments to \code{dot_error()}, currently ignored}
}
\value{
  Always returns an object of the same class as \code{xy}.
}
\author{Robin K. S. Hankin}
\examples{
x <- rcliff()
y <- rcliff()
z <- rcliff()

.[x,.[y,z]] + .[y,.[z,x]] + .[z,.[x,y]]  # Jacobi identity


}
