% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cifcurve.R
\name{cifcurve}
\alias{cifcurve}
\title{Calculate the Kaplan-Meier estimator and the Aalen-Johansen estimator}
\usage{
cifcurve(
  formula,
  data,
  weights = NULL,
  n.risk.type = "weighted",
  subset.condition = NULL,
  na.action = na.omit,
  outcome.type = c("survival", "competing-risk"),
  code.event1 = 1,
  code.event2 = 2,
  code.censoring = 0,
  error = NULL,
  conf.type = "arcsine-square root",
  conf.int = 0.95,
  report.influence.function = FALSE,
  report.survfit.std.err = FALSE,
  engine = "calculateAJ_Rcpp",
  prob.bound = 1e-07
)
}
\arguments{
\item{formula}{A model formula specifying the time-to-event outcome on the LHS
(typically \code{Event(time, status)} or \code{survival::Surv(time, status)})
and, optionally, a stratification variable on the RHS.
Unlike \code{\link[=cifplot]{cifplot()}}, this function does not accept a fitted survfit object.}

\item{data}{A data frame containing variables in the formula.}

\item{weights}{Optional name of the weight variable in \code{data}. Weights must be nonnegative.}

\item{n.risk.type}{Character string; one of \code{"weighted"}, \code{"unweighted"}, or \code{"ess"}.
Controls which risk set size is returned in \verb{$n.risk} without affecting estimates
or standard errors. (default \code{"weighted"}).}

\item{subset.condition}{Optional character string giving a logical condition to subset
\code{data} (default \code{NULL}).}

\item{na.action}{A function specifying the action to take on missing values (default \code{na.omit}).}

\item{outcome.type}{Character string specifying the type of time-to-event outcome.
One of \code{"survival"} (Kaplan-Meier) or \code{"competing-risk"} (Aalen-Johansen).
If \code{NULL} (default), the function automatically infers the outcome type from the data:
if the event variable has more than two unique levels, \code{"competing-risk"} is assumed;
otherwise, \code{"survival"} is used. You can also use abbreviations such as \code{"S"} or \code{"C"}.
Mixed or ambiguous inputs (e.g., \code{c("S", "C")}) trigger automatic detection based on the event coding.}

\item{code.event1}{Integer code of the event of interest (default \code{1}).}

\item{code.event2}{Integer code of the competing risk (default \code{2}).}

\item{code.censoring}{Integer code of censoring (default \code{0}).}

\item{error}{Character string specifying the method for SEs and CIs used internally.
For \code{"survival"} without weights, choose one of \code{"greenwood"} (default), \code{"tsiatis"}, or \code{"if"}.
For \code{"competing-risk"} without weights, choose one of \code{"delta"} (default), \code{"aalen"}, or \code{"if"}.
SEs and CIs based on influence functions (\code{"if"}) is recommended for weighted analysis.}

\item{conf.type}{Character specifying the method of transformation for CIs
used internally (default \verb{arcsine-square root}).}

\item{conf.int}{Numeric two-sided level of CIs (default \code{0.95}).}

\item{report.influence.function}{Logical. When \code{TRUE} and \code{engine = "calculateAJ_Rcpp"},
the influence function is also computed and returned (default \code{FALSE}).}

\item{report.survfit.std.err}{Logical. If \code{TRUE}, report SE on the log-survival
scale (survfit's convention). Otherwise SE is on the probability scale.}

\item{engine}{Character. One of \code{"auto"}, \code{"calculateKM"}, or \code{"calculateAJ_Rcpp"} (default \code{"calculateAJ_Rcpp"}).}

\item{prob.bound}{Numeric lower bound used to internally truncate probabilities away from 0 and 1 (default \code{1e-7}).}
}
\value{
A \code{"survfit"} object. For \code{outcome.type="survival"}, \verb{$surv} is the survival function.
For \code{outcome.type="competing-risk"}, \verb{$surv} equals \code{1 - CIF} for \code{code.event1}.
SE and CIs are provided per  \code{error}, \code{conf.type} and \code{conf.int}.
This enables an independent use of standard methods for \code{survfit} such as:
\itemize{
\item \code{summary()}: time-by-time estimates with SEs and CIs
\item \code{plot()}: base R stepwise survival/CIF curves
\item \code{mean()}: restricted mean survival estimates with CIs
\item \code{quantile()}: quantile estimates with CIs
}

Note that \verb{$n.risk}, \verb{$n.event}, and \verb{$n.censor} are rounded up to the nearest integer
regardless of whether the data is weighted or not.
Some methods (e.g. \code{residuals.survfit}) may not be supported.
}
\description{
Core estimation routine that computes a survfit-compatible object
from a formula + data interface (\code{Event()} or \code{survival::Surv()} on
the LHS, and a stratification variable on the RHS if necessary).
The back-end  C++ routine supports both weighted and stratified data. Use this
when you want \strong{numbers only} (e.g. estimates, SEs, CIs and influence functions)
and will plot it yourself.
}
\details{
\subsection{Typical use cases}{
\itemize{
\item When \code{outcome.type = "survival"}, this is a thin wrapper around
the KM estimator with the chosen variance / CI transformation.
\item When \code{outcome.type = "competing-risk"}, this computes the AJ estimator of CIF for \code{code.event1}.
The returned \verb{$surv} is \strong{1 - CIF}, i.e. in the format that ggsurvfit expects.
\item Use \code{\link[=cifplot]{cifplot()}} if you want to go straight to a figure; use \code{\link[=cifcurve]{cifcurve()}} if you only want the numbers.
}
}

\subsection{Risk set display}{
\itemize{
\item Set \code{n.risk.type} to control whether \verb{$n.risk} reflects weighted, unweighted,
or Kish effective sample size (ESS) counts. This only affects the reported
counts (e.g., for plotting or debugging) and leaves estimates and SEs unchanged.
}
}

\subsection{Standard error and confidence intervals}{\tabular{lll}{
   Argument \tab Description \tab Default \cr
   \code{error} \tab SE for KM: \code{"greenwood"}, \code{"tsiatis"}, \code{"if"}. For CIF: \code{"aalen"}, \code{"delta"}, \code{"if"}. \tab \code{"greenwood"}, \code{"delta"} or \code{"if"} \cr
   \code{conf.type} \tab Transformation for CIs: \code{"plain"}, \code{"log"}, \code{"log-log"}, \code{"arcsin"}, \code{"logit"}, or \code{"none"}. \tab \code{"arcsin"} \cr
   \code{conf.int} \tab Two-sided CI level. \tab \code{0.95} \cr
}

}
}
\section{Lifecycle}{

\lifecycle{stable}
}

\examples{
data(diabetes.complications)
output1 <- cifcurve(Event(t,epsilon) ~ fruitq,
                    data = diabetes.complications,
                    outcome.type="competing-risk")
cifplot(output1,
        outcome.type = "competing-risk",
        type.y = "risk",
        add.risktable = FALSE,
        label.y = "CIF of diabetic retinopathy",
        label.x = "Years from registration")

}
\seealso{
\code{\link[=polyreg]{polyreg()}} for log-odds product modeling of CIFs; \code{\link[=cifplot]{cifplot()}} for display of a CIF; \code{\link[=cifpanel]{cifpanel()}} for display of multiple CIFs; \link[ggsurvfit:ggsurvfit]{ggsurvfit::ggsurvfit}, \link[patchwork:patchwork-package]{patchwork::patchwork} and \link[modelsummary:modelsummary]{modelsummary::modelsummary} for display helpers.
}
