% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cif-visual-arguments.R
\name{cif-visual-arguments}
\alias{cif-visual-arguments}
\title{These arguments are shared by \code{\link[=cifplot]{cifplot()}} and \code{\link[=cifpanel]{cifpanel()}}.}
\arguments{
\item{add.risktable}{Logical; if \code{TRUE}, adds a numbers-at-risk table under the plot.
Default \code{TRUE}. \strong{Note:} when a panel mode is active, tables are suppressed.}

\item{add.estimate.table}{Logical; if \code{TRUE}, adds a table of estimates and CIs.
Default \code{FALSE}. \strong{Note:} when a panel mode is active, tables are suppressed.}

\item{symbol.risk.table}{Character specifying the symbol used in the risk table to denote
strata: \code{"square"}, \code{"circle"}, or \code{"triangle"} (default \code{"square"}).}

\item{font.size.risk.table}{Numeric font size for texts in risk / estimate tables (default \code{3}).}

\item{label.strata}{Character vector or named character vector specifying labels for strata.
Names (if present) must match the (re-ordered) underlying strata levels.
\strong{Note:} when any of the panel modes is active
(\code{panel.per.variable = TRUE}, \code{panel.per.event = TRUE}, \code{panel.censoring = TRUE},
or \code{panel.mode = "auto"} and it actually dispatches to a panel),
strata labels are suppressed to avoid duplicated legends across sub-plots.}

\item{level.strata}{Optional character vector giving the full set of expected strata levels.
When provided, both \code{order.strata} and \code{label.strata} are validated against it
before application.}

\item{order.strata}{Optional character vector specifying the display order of strata
in the legend/number-at-risk table. Specify the levels of strata. Levels not listed are dropped.}

\item{legend.position}{Character specifying the legend position:
\code{"top"}, \code{"right"}, \code{"bottom"}, \code{"left"}, or \code{"none"} (default \code{"top"}).}

\item{type.y}{Character string specifying the y-scale. For survival/CIF curves,
\code{"surv"} implies survival probabilities and \code{"risk"} implies CIF
(1-survival in simple survival settings). Specify \code{"cumhaz"} to plot cumulative hazard
or \code{"cloglog"} to generate a complementary log-log plot.
If \code{NULL}, a default is chosen from \code{outcome.type} or the survfit object.}

\item{label.x}{Character x-axis label (default \code{"Time"}).}

\item{label.y}{Character y-axis label (default is chosen automatically from \code{outcome.type}
and \code{type.y}, e.g. "Survival", "Cumulative incidence" or "Cumulative hazard").}

\item{limits.x}{Numeric length-2 vector specifying x-axis limits. If \code{NULL}, it is
set from the fitted object (typically \code{c(0, max(time))}).}

\item{limits.y}{Numeric length-2 vector specifying y-axis limits. If \code{NULL}, it is
set to \code{c(0, 1)} for probability-type outcomes.}

\item{breaks.x}{Numeric vector of x-axis breaks (default \code{NULL}).}

\item{breaks.y}{Numeric vector of y-axis breaks (default \code{NULL}).}

\item{use.coord.cartesian}{Logical; if \code{TRUE}, uses \code{ggplot2::coord_cartesian()} for zooming
instead of changing the scale limits (default \code{FALSE}).}

\item{add.conf}{Logical; if \code{TRUE}, adds a CI ribbon
(via \code{ggsurvfit::add_confidence_interval()}). Default \code{TRUE}.}

\item{add.censor.mark}{Logical; if \code{TRUE}, draws censoring marks on each curve
(via \code{ggsurvfit::add_censor_mark()}). Default \code{TRUE}.}

\item{shape.censor.mark}{Integer point shape used for censoring marks (default \code{3}).}

\item{size.censor.mark}{Numeric point size used for censoring marks (default \code{2}).}

\item{add.competing.risk.mark}{Logical; if \code{TRUE}, draws time marks for the competing event
(event 2). If no times are supplied via \code{competing.risk.time}, the function tries to
extract them automatically from the data. Default \code{FALSE}.}

\item{competing.risk.time}{A \strong{named list} of numeric vectors. Each name must correspond to a
strata label, and its numeric vector gives the times at which the competing event occurred
in that stratum. Typically left as \code{list()} and filled internally.}

\item{shape.competing.risk.mark}{Integer point shape for competing-risk marks (default \code{16}).}

\item{size.competing.risk.mark}{Numeric point size for competing-risk marks (default \code{2}).}

\item{add.intercurrent.event.mark}{Logical; if \code{TRUE}, overlays user-specified intercurrent-event
times per stratum. Default \code{FALSE}.}

\item{intercurrent.event.time}{A \strong{named list} of numeric vectors for intercurrent events
(names must match strata labels).}

\item{shape.intercurrent.event.mark}{Integer point shape for intercurrent-event marks
(default \code{1}).}

\item{size.intercurrent.event.mark}{Numeric point size for intercurrent-event marks
(default \code{2}).}

\item{add.quantile}{Logical; if \code{TRUE}, adds a quantile reference line (via
\code{ggsurvfit::add_quantile()}). Default \code{FALSE}.}

\item{level.quantile}{Numeric quantile level to be shown (default \code{0.5} for the median).}

\item{rows.columns.panel}{Optional integer vector \code{c(nrow, ncol)} controlling
the layout of the panel returned by the panel modes. If \code{NULL}, an automatic
layout is determined from the number of subplots.}

\item{style}{Character choosing the base plot style: \code{"classic"}, \code{"bold"},
\code{"framed"}, \code{"grid"}, \code{"gray"} or \code{"ggsurvfit"} (default \code{"classic"}).
Abbreviations such as \code{"C"}, \code{"B"}, \code{"F"}, or \code{"G"} are also accepted.}

\item{palette}{Optional character vector specifying the color palette to use across strata.}

\item{linewidth}{Optional numeric specifying the line width of curve (default \code{0.8}).}

\item{linetype}{Optional logical using different line types of curve (default \code{FALSE}).}

\item{font.family}{Character specifying the font family: \code{"sans"},  \code{"serif"}, or
\code{"mono"} (default \code{"sans"}).}

\item{font.size}{Integer specifying the base font size (default \code{12}).}

\item{print.panel}{Logical. When \code{TRUE}, panel displays created internally are
printed automatically in interactive sessions; otherwise they are returned
invisibly for further modification (default \code{FALSE}).}

\item{filename.ggsave}{Character; if non-\code{NULL}, save the plot to this file.}

\item{width.ggsave}{Numeric width passed to \code{ggplot2::ggsave()} (default \code{6}).}

\item{height.ggsave}{Numeric height passed to \code{ggplot2::ggsave()} (default \code{6}).}

\item{dpi.ggsave}{Numeric DPI passed to \code{ggplot2::ggsave()} (default \code{300}).}
}
\description{
These arguments are shared by \code{\link[=cifplot]{cifplot()}} and \code{\link[=cifpanel]{cifpanel()}}.
}
\keyword{internal}
