% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ci_mean_t_stat}
\alias{ci_mean_t_stat}
\title{Mean CI from Descriptive Statistics}
\usage{
ci_mean_t_stat(mean_, sd_, n, group = "", conf.level = 0.95)
}
\arguments{
\item{mean_}{Vector of group means.}

\item{sd_}{Vector of group standard deviations.}

\item{n}{Vector of group sizes.}

\item{group}{Group name. Default: empty string (\code{""}).}

\item{conf.level}{Confidence level. Default: 0.95.}
}
\value{
A data frame with columns:
\itemize{
\item \code{group}  (\verb{<fct>}) -- group name;
\item \code{mean}   (\verb{<dbl>}) -- mean estimate;
\item \code{lwr.ci} (\verb{<dbl>}) -- lower CI bound (lwr. = lower);
\item \code{upr.ci} (\verb{<dbl>}) -- upper CI bound (upr. = upper);
\item \code{sd}     (\verb{<dbl>}) -- standard deviation;
\item \code{n}      (\verb{<int>}) -- sample/group size.
}

Calculations can be performed for multiple groups simultaneously.
}
\description{
\code{ci_mean_t_stat()} calculates the mean's confidence interval (CI)
using the \emph{classic} formula with Student's t coefficient when
descriptive statistics (mean, standard deviation, sample size) are provided.
Useful when these values are reported in scientific literature.
}
\note{
Each of \code{mean_}, \code{sd_}, \code{n}, \code{group} must have length
(a) of one value, or
(b) matching the longest vector in this argument group.

See examples for clarification.
}
\examples{
# Basic example: Test scores
# Suppose a class of 25 students has a mean score of 75 with SD of 10
ci_mean_t_stat(mean_ = 75, sd_ = 10, n = 25)

# The result tells us we can be 95\% confident that the true mean score
# lies between the lower and upper CI bounds

# Example from literature: A study reports mean = 362, SD = 35, n = 100
ci_mean_t_stat(mean_ = 362, sd_ = 35, n = 100)

# Without argument names (order matters: mean, sd, n):
ci_mean_t_stat(362, 35, 100)


# Comparing multiple groups (e.g., teaching methods):
# Method A: mean = 78, SD = 8, n = 30 students
# Method B: mean = 82, SD = 7, n = 28 students
# Method C: mean = 75, SD = 9, n = 32 students
mean_val <- c(78, 82, 75)
std_dev  <- c(8,   7,  9)
n        <- c(30, 28, 32)
group    <- c("Method A", "Method B", "Method C")

ci_mean_t_stat(mean_val, std_dev, n, group)


# Educational example: Effect of sample size on CI width
# Same mean and SD, but different sample sizes
ci_mean_t_stat(mean_ = 75, sd_ = 10, n = c(10, 25, 50, 100))
# Notice: Larger samples give narrower (more precise) confidence intervals


# Educational example: Changing confidence level (default is 95\%)
ci_mean_t_stat(mean_ = 75, sd_ = 10, n = 25, conf.level = 0.99)
# 99\% CI is wider than 95\% CI (more confident = less precise)

# NOTE: Changing conf.level just to get narrower CI is a BAD PRACTICE!
# Please choose confidence level based on study design, not desired CI width.


# To display more decimal places, convert tibble to data frame:
result_ci <- ci_mean_t_stat(75, 10, 25)
as.data.frame(result_ci)

# Or use:
# View(result_ci)

}
