% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chronochrt-package.R
\docType{package}
\name{chronochrt-package}
\alias{chronochrt}
\alias{chronochrt-package}
\title{ChronochRt}
\description{
ChronochRt offers an easy way to draw chronological charts from tables. It
aims to provide an intuitive environment for anyone new to R.
}
\section{Features}{
 \itemize{\item Slim structure of chronological datasets
  \item Import tabular data files and \item Import Excel files (requires the
  package \pkg{readxl} \item Possibility to display up to 2 chronological
  systems within the same region (e.g. long and short chronologies) \item
  Layout of the chronological chart optimised for easy readability and
  comprehensibility \item Years in BCE must be negative - that's all you need
  to care about for dates \item Handling of insecure dates \item Handling of
  gaps, e.g. abandonment phases of sites \item Optional text labels \item
  Optional image labels to e.g. display key finds or show typological
  developments \item Geoms for the chronological chart and image labels \item
  Export of the chronological chart in different file formats (raster and
  vector graphics) \item Easy customisation of the chronological chart \item
  Based on the \href{https://tidyverse.org/}{tidyverse}: Seamless
  integration in pipes, enhanced customisation with \pkg{ggplot2}}
}

\section{Getting started}{
 \itemize{ \item
  \href{https://github.com/archaeothommy/chronochrt/blob/main/inst/ChronochRt_Cheatsheet.pdf}{Cheatsheet}
   \item Vignettes}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/archaeothommy/chronochrt}
  \item Report bugs at \url{https://github.com/archaeothommy/chronochrt/issues}
}

}
\author{
\strong{Maintainer}: Thomas Rose \email{roseth@posteo.com} (\href{https://orcid.org/0000-0002-8186-3566}{ORCID})

Authors:
\itemize{
  \item Chiara Girotto \email{chiara.girotto@web.de} (\href{https://orcid.org/0000-0001-6412-342X}{ORCID})
}

}
