% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phrase_counts.R
\name{phrase_counts}
\alias{phrase_counts}
\title{Count phrase matches in CHILDES utterances (experimental)}
\usage{
phrase_counts(
  phrases,
  collection = NULL,
  language = NULL,
  corpus = NULL,
  age = NULL,
  sex = NULL,
  role = NULL,
  role_exclude = NULL,
  wildcard = FALSE,
  ignore_case = TRUE,
  normalize = FALSE,
  per_utts = 10000L,
  db_version = "current",
  cache = FALSE,
  cache_dir = NULL,
  output_file = NULL
)
}
\arguments{
\item{phrases}{Character vector of phrases or patterns.}

\item{collection, language, corpus, age, sex, role, role_exclude}{CHILDES filters.}

\item{wildcard}{Logical; enable * and ? in phrases.}

\item{ignore_case}{Logical; case-insensitive matching.}

\item{normalize}{Logical; if TRUE, add per-N utterance rates.}

\item{per_utts}{Integer; denominator for utterance rates (default 10000).}

\item{db_version}{CHILDES DB version (recorded).}

\item{cache}{Logical; cache CHILDES queries on disk.}

\item{cache_dir}{Optional cache directory.}

\item{output_file}{Optional .xlsx path; if NULL, returns a tibble.}
}
\value{
If output_file is NULL, returns a tibble of phrase counts; otherwise
writes an Excel file and returns the file path (invisibly).
}
\description{
Matches surface phrases in utterance text and outputs counts, plus dataset
summary and run metadata. Supports simple wildcards in phrases: * (any chars),
? (one char). Normalization is per number of utterances.
}
\details{
Tier targeting is not applied in phrase mode. Phrases are matched in
the main utterance text. For tier-constrained contexts around words, use
\code{contexts_for(..., mode = "word", tier = "mor")}.
}
