% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cptgaisl-class.R
\docType{class}
\name{cptgaisl-class}
\alias{cptgaisl-class}
\alias{summary,cptgaisl-method}
\alias{summary.cptgaisl}
\title{S4 Class Definition for `cptgaisl`}
\usage{
\S4method{summary}{cptgaisl}(object, ...)
}
\arguments{
\item{object}{An object of class \code{cptgaisl}.}

\item{...}{Additional arguments (ignored).}
}
\value{
An object of class \code{cptgaisl}
}
\description{
S4 Class for Island Model Genetic Algorithm-Based Changepoint Detection
}
\details{
This class stores results and settings for the island model genetic algorithm (`cptgaisl`)
used in multiple changepoint detection and optional model order selection.
}
\section{Slots}{

\describe{
\item{\code{call}}{The matched call that created the object.}

\item{\code{N}}{The sample size of the time series.}

\item{\code{prange}}{A list or NULL. Ranges for each model order parameter when \code{option = "both"}.}

\item{\code{popSize}}{Integer. It represents the total number of individuals in each generation, which equal to the number of islands multiplied by the size of each island (i.e., \code{popSize = numIslands × Islandsize}).}

\item{\code{numIslands}}{Integer. The number of islands (sub-populations).}

\item{\code{Islandsize}}{Numerical value. The number of individuals in each island.}

\item{\code{pcrossover}}{Probability of crossover operation.}

\item{\code{pmutation}}{Probability of mutation operation.}

\item{\code{pchangepoint}}{Prior probability of changepoint occurrence.}

\item{\code{minDist}}{Minimum distance between adjacent changepoints.}

\item{\code{mmax}}{Maximum number of changepoints allowed.}

\item{\code{lmax}}{Maximum length of chromosome.}

\item{\code{maxMig}}{Maximum number of migrations allowed.}

\item{\code{maxgen}}{Maximum number of generations per island before migration.}

\item{\code{maxconv}}{Number of migrations with no improvement before stopping.}

\item{\code{option}}{Either "cp" or "both".}

\item{\code{monitoring}}{Logical. If TRUE, prints intermediate output.}

\item{\code{parallel}}{Logical. Whether parallel computation is used.}

\item{\code{nCore}}{Integer or NULL. Number of cores for parallelization.}

\item{\code{tol}}{Tolerance threshold for fitness improvement.}

\item{\code{seed}}{Integer or NULL. Seed for reproducibility.}

\item{\code{suggestions}}{A list or NULL. Suggested changepoint configurations.}

\item{\code{Island}}{A 3D array storing all individual chromosomes in current generation across islands. Dimensions are \code{lmax} × \code{Islandsize} × \code{numIslands}, representing chromosome length, individuals per island, and number of islands, respectively.}

\item{\code{IslandFit}}{A matrix of fitness values in current generation with dimensions \code{Islandsize} × \code{numIslands}, where each column corresponds to one island's population.}

\item{\code{overbestchrom}}{A vector. The best chromosome ever found.}

\item{\code{overbestfit}}{Numeric. The best fitness score obtained.}

\item{\code{bestfit}}{Numeric vector recording best fitness per migration.}

\item{\code{countMig}}{Integer vector tracking number of migrations.}

\item{\code{count}}{Integer vector tracking total generations.}

\item{\code{convg}}{Integer vector for convergence diagnostics.}
}}

\seealso{
\code{\link{cptgaisl}}, \code{\link{cptgaisl-class}}, \code{\link{random_population}}, \code{\link{selection_linearrank}}, \code{\link{uniformcrossover}}, \code{\link{mutation}}.
}
