% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cptga-class.R
\docType{class}
\name{cptga-class}
\alias{cptga-class}
\alias{summary,cptga-method}
\alias{summary.cptga}
\title{S4 Class Definition for `cptga`}
\usage{
\S4method{summary}{cptga}(object, ...)
}
\arguments{
\item{object}{An object of class \code{cptga}.}

\item{...}{Additional arguments (ignored).}
}
\value{
An object of class \code{cptga}.
}
\description{
S4 Class for Genetic Algorithm-Based Changepoint Detection
}
\details{
An object of class \code{cptga} stores results and configuration settings
for changepoint detection using a Genetic Algorithm (GA), optionally with
simultaneous model order selection. This class records GA control parameters,
intermediate population structures, and the optimal solution found.
}
\section{Slots}{

\describe{
\item{\code{call}}{The matched call that created the object.}

\item{\code{N}}{The sample size of the time series.}

\item{\code{prange}}{A list object. Default is \code{NULL}. If specified, it contains the
ranges for each model order parameter (integers). Required when \code{option = "both"}
is used for joint changepoint and model selection.}

\item{\code{popSize}}{An integer representing the number of individuals in each GA population.}

\item{\code{pcrossover}}{The probability that the crossover operator is applied to two chromosomes.}

\item{\code{pmutation}}{The probability that the mutation operator is applied to a chromosome.}

\item{\code{pchangepoint}}{The prior probability that a changepoint has occurred at each location.}

\item{\code{minDist}}{The minimum allowed distance between two adjacent changepoints.}

\item{\code{mmax}}{The maximum possible number of changepoints. Typically set based on time series length and \code{option}.}

\item{\code{lmax}}{The maximum length of the chromosome. Typically set based on time series length and \code{option}.}

\item{\code{maxgen}}{The maximum number of generations the GA is allowed to run.}

\item{\code{maxconv}}{If the optimal fitness value does not improve over this many generations, GA stops.}

\item{\code{option}}{A character string: either \code{"cp"} for changepoint detection only, or \code{"both"} for changepoint detection and model order selection.}

\item{\code{monitoring}}{Logical. If \code{TRUE}, prints intermediate GA progress.}

\item{\code{parallel}}{Logical. If \code{TRUE}, enables parallel computation for fitness evaluation.}

\item{\code{nCore}}{Integer or \code{NULL}. Number of cores used for parallel computation when \code{parallel = TRUE}.}

\item{\code{tol}}{Numeric. Tolerance for determining GA convergence. Default is \code{1e-5}.}

\item{\code{seed}}{An integer or \code{NULL}. Random seed for reproducibility.}

\item{\code{suggestions}}{A list or \code{NULL}. Each element provides suggested changepoint locations
to guide initial population design and potentially accelerate convergence.}

\item{\code{population}}{A matrix where each row represents an individual chromosome in the current population.}

\item{\code{fitness}}{A numeric vector containing the fitness values of individuals in the current generation.}

\item{\code{overbestchrom}}{A vector representing the best chromosome found over all generations.}

\item{\code{overbestfit}}{A numeric scalar. The best (smallest) fitness value achieved.}

\item{\code{bestfit}}{A numeric vector recording the best fitness value in each generation.}

\item{\code{count}}{A numeric value indicating the number of generations the GA actually ran.}

\item{\code{convg}}{A numeric vector representing convergence information. A value of \code{0} indicates the algorithm successful completion. A value of \code{1} indicates the the total number of generations exceeds the pre-specified \code{maxgen} limit.}
}}

\seealso{
\code{\link{cptga}}, \code{\link{cptga-class}}, \code{\link{random_population}}, \code{\link{selection_linearrank}}, \code{\link{uniformcrossover}}, \code{\link{mutation}}.
}
