% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgmguru-functions-docs.R
\name{mod_grid}
\alias{mod_grid}
\title{Modified GRID Analysis}
\usage{
mod_grid(df, grid_point_df, hours = 2, gap = 15)
}
\arguments{
\item{df}{A dataframe containing continuous glucose monitoring (CGM) data.
Must include columns:
\itemize{
  \item \code{id}: Subject identifier (string or factor)
  \item \code{time}: Time of measurement (POSIXct)
  \item \code{gl}: Glucose value (integer or numeric, mg/dL)
}}

\item{grid_point_df}{A dataframe with column \code{start_indices} (start points for re-applied GRID)}

\item{hours}{Time window in hours for analysis (default: 2)}

\item{gap}{Gap threshold in minutes for event detection (default: 15).
This parameter defines the minimum time interval between consecutive GRID events.}
}
\value{
A list containing:
\itemize{
  \item \code{mod_grid_vector}: Tibble with modified GRID results (\code{mod_grid})
  \item \code{episode_counts}: Tibble with episode counts per subject (\code{id}, \code{episode_counts})
  \item \code{episode_start}: Tibble with all episode starts with columns:
    \itemize{
      \item \code{id}: Subject identifier
      \item \code{time}: Timestamp at which the event occurs; equivalent to \code{df$time[indices]}
      \item \code{gl}: Glucose value at the event; equivalent to \code{df$gl[indices]}
      \item \code{indices}: R-based (1-indexed) row number(s) in \code{df} denoting where the event occurs
    }
}
}
\description{
Constructs a modified GRID series by reapplying the GRID logic with a designated
gap (e.g., 60 minutes) and analysis window in hours (e.g., 2 hours). It
reassigns GRID events under these constraints to produce a modified grid
suitable for downstream maxima mapping and episode analysis.
}
\section{Units and sampling}{

- \code{gap} is minutes; \code{hours} is hours; \code{time} is POSIXct.
}

\examples{
# Load sample data
library(iglu)
data(example_data_5_subject)
data(example_data_hall)

# First, get grid points
grid_result <- grid(example_data_5_subject, gap = 60, threshold = 130)

# Perform modified GRID analysis
mod_result <- mod_grid(example_data_5_subject, grid_result$grid_vector, hours = 2, gap = 60)
print(paste("Modified grid points:", nrow(mod_result$mod_grid_vector)))

# Modified analysis with different parameters
mod_result_1h <- mod_grid(example_data_5_subject, grid_result$grid_vector, hours = 1, gap = 40)

# Analysis on larger dataset
large_grid <- grid(example_data_hall, gap = 60, threshold = 130)
large_mod_result <- mod_grid(example_data_hall, large_grid$grid_vector, hours = 2, gap = 60)
print(paste("Modified grid points in larger dataset:", nrow(large_mod_result$mod_grid_vector)))
}
\seealso{
\link{grid}, \link{find_max_after_hours}, \link{find_new_maxima}

Other GRID pipeline: 
\code{\link{detect_between_maxima}()},
\code{\link{find_local_maxima}()},
\code{\link{find_max_after_hours}()},
\code{\link{find_max_before_hours}()},
\code{\link{find_min_after_hours}()},
\code{\link{find_min_before_hours}()},
\code{\link{find_new_maxima}()},
\code{\link{grid}()},
\code{\link{maxima_grid}()},
\code{\link{start_finder}()},
\code{\link{transform_df}()}
}
\concept{GRID pipeline}
