% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censuspyrID.R
\name{area_trends}
\alias{area_trends}
\title{Plot Population Area Trends by Age Group and Sex}
\usage{
area_trends(data, sex = 1, color = "Fresh and bright")
}
\arguments{
\item{data}{A data frame containing population trends data for a specific
region over years. Must include variables \code{year}, \code{sex},
\code{age5}, and \code{pop}.}

\item{sex}{Integer indicating which sex to include in the plot:
\itemize{
\item 1 = All sexes
\item 2 = Male
\item 3 = Female
\item 4 = Male+Female
}
Default is 1 (all sexes).}

\item{color}{Character string specifying the palette name from
\code{ggthemes::canva_palettes}. Default is \code{"Fresh and bright"}.}
}
\value{
A \code{ggplot2} object showing the population area trends.
}
\description{
This function builds an area plot showing the proportion of population
distributed across three broad age groups (young, working-age, old)
over census years. The plot can be displayed separately by sex or combined.
}
\details{
The function aggregates population into three age groups:
\itemize{
\item 0–14 years (Young)
\item 15–64 years (Working age)
\item 65+ years (Old)
}
It then calculates the proportion of each age group within each sex and year.
The result is plotted as a stacked area chart, optionally faceted by sex.
}
\examples{
\dontrun{
# Example: area trends for Indonesia
data_idn <- load_pop_data(harmonized = TRUE, smoothing = 1) |>
  pop_data_by_reg(0) #Indonesia
area_trends(data_idn, sex = 1) #All sexes
area_trends(data_idn, sex = 2) #Male
area_trends(data_idn, sex = 3) #Female
area_trends(data_idn, sex = 4) #Male+Female
}

}
\seealso{
\code{\link[=pyr_trends]{pyr_trends()}}, \code{\link[=load_pop_data]{load_pop_data()}}, \code{\link[=pop_data_by_reg]{pop_data_by_reg()}}, \code{\link[=get_code_label]{get_code_label()}}
}
