% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paneltestDML.R
\name{paneltestDML}
\alias{paneltestDML}
\title{paneltestDML: Overidentification test for ATET estimation in panel data}
\usage{
paneltestDML(y1, y0, d, x, trim = 0.05, MLmethod = "lasso", k = 4)
}
\arguments{
\item{y1}{Outcome variable in the post-treatment period. Should not contain missing values.}

\item{y0}{Outcome variable in the pre-treatment period. Should not contain missing values.}

\item{d}{Treatment group indicator (binary). Should not contain missing values.}

\item{x}{Covariates to be controlled for. Should not contain missing values.}

\item{trim}{Trimming threshold for discarding observations with too extreme treatment propensity scores (smaller than trim or larger than 1-trim). Default is 0.05.}

\item{MLmethod}{Machine learning method for estimating nuisance parameters using the \code{SuperLearner} package. Must be one of \code{"lasso"} (default), \code{"randomforest"}, \code{"xgboost"}, \code{"svm"}, \code{"ensemble"}, or \code{"parametric"}.}

\item{k}{Number of folds in k-fold cross-fitting. Default is 4.}
}
\value{
A list with the following components:
\item{est}{Test statistic.}
\item{se}{Standard error.}
\item{pval}{P-value.}
\item{ntrimmed}{Number of trimmed or dropped observations due to propensitiy scores below the threshold \code{trim}.}
\item{pscore.xy0}{Propensity score under unconfoundedness.}
\item{pscore.x}{Propensity score under conditional common trends.}
\item{ATETselobs}{ATET based on the selection on observables/unconfoundedness assumption.}
\item{seATETselobs}{Standard error of the ATET based on the selection on observables/unconfoundedness assumption.}
\item{ATETdid}{ATET based on difference-in-differences invoking the conditional common trends assumption.}
\item{seATETdid}{Standard error of the ATET based on difference-in-differences invoking the conditional common trends assumption.}
}
\description{
This function applies an overidentification test to assess if unconfoundedness of the treatments and conditional common trends as imposed in differences-in-differences jointly hold in panel data when evaluating the average treatment effect on the treated (ATET).
}
\details{
The test statistic corresponds to the difference between the ATETs that are based on two distinct doubly robust score functions, namely that under unconfoundedness and that based on difference-in-differences under conditional common trends. Estimation in panel data is based on double machine learning and the function supports different machine learning methods to estimate nuisance parameters (conditional mean outcomes and propensity scores) as well as cross-fitting to mitigate overfitting.
}
\examples{
\dontrun{
n=1000
x=data.frame(rnorm(n), rnorm(n))
d=1*(0.5*x[,1]+rnorm(n)>0)
y0=rnorm(n)
y1=0.5*x[,1]+y0+d+rnorm(n)
# report p-value (note that unconfoundedness and common trends hold jointly)
paneltestDML(y1=y1, y0=y0, d=d, x=x)$pval
}
}
\references{
Huber, M., and Oeß, E.-M. (2024): "A joint test of unconfoundedness and common trends", arXiv preprint 2404.16961.
}
