% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sdo_cat}
\alias{sdo_cat}
\title{Social Dominance Orientation Cat Object}
\format{
An object of class \code{Cat} of length 1.
}
\source{
See \code{https://dataverse.harvard.edu/dataverse/pdsl} for the raw YouGov and/or Qualtrics data.
}
\usage{
data(sdo_cat)
}
\description{
Cat object containing item parameters for graded response model fit with responses to the 15 item Social Dominance Orientation inventory
}
\details{
Cat object containing item parameters for graded response model fit with
2042 response profiles from Lucid, 1192 response profiles from MTurk,
and 1482 response profiles collected by YouGov in June 2018.  The sample from MTurk was a convenience sample
The respondents from YouGov were matched to a sampling frame on gender, age, race, and education.

See \code{\link{Cat-class}} for details regarding the Cat object structure.
See \code{\link{grmCat}} for details regarding the graded response model.

A normal prior was chosen with mean from the theta estimates from the YouGov sample (.19) and a standard deviation (1)
wide enough to envelope the range of estimated theta values across both samples.

Note that due to how the item parameters were estimated, large, positive values indicate "more" of the latent trait.

Response options are:

5 = Strongly agree, 4 = Somewhat agree, 3 = Neither agree nor disagree, 2 = Somewhat disagree, 1 = Strongly disagree

The wording of the question items is: 

\describe{
\item{\code{q1}}{    Some groups of people are simply inferior to other groups.}
\item{\code{q2}}{    In getting what you want, it is sometimes necessary to use force against other groups.}
\item{\code{q3}}{    It's OK if some groups have more of a chance in life than others.}
\item{\code{q4}}{    To get ahead in life, it is sometimes necessary to step on other groups.}
\item{\code{q5}}{    If certain groups stayed in their place, we would have fewer problems.}
\item{\code{q6}}{    It's probably a good thing that certain groups are at the top and other groups are at the bottom.}
\item{\code{q7}}{    Inferior groups should stay in their place.}
\item{\code{q8}}{    Sometimes other groups must be kept in their place.}
\item{\code{q9}}{    It would be good if groups could be equal.}
\item{\code{q10}}{    Group equality should be our ideal.}
\item{\code{q11}}{    All groups should be given an equal chance in life.}
\item{\code{q12}}{    We should do what we can to equalize conditions for different groups.}
\item{\code{q13}}{    Increased social equality is beneficial to society.}
\item{\code{q14}}{    We would have fewer problems if we treated people more equally.}
\item{\code{q15}}{    We should strive to make incomes as equal as possible.}
\item{\code{q16}}{    No group should dominate in society.}
}
}
\references{
Pratto, F., J. Sidanius, L. M. Stallworth, and B. F. Malle (1994), "Social Dominance Orientation: A
Personality Variable Predicting Social and Political Attitudes," Journal of Personality and
Social Psychology, 67, 741.
}
\seealso{
\code{\link{Cat-class}}, \code{\link{grmCat}}
}
\keyword{datasets}
