% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covar_sim.R
\name{covar_loggamma}
\alias{covar_loggamma}
\title{Simulate from a log gamma-gaussian copula distribution}
\usage{
covar_loggamma(
  n,
  normal.cor = NULL,
  gamma.var = 1,
  names = c("z"),
  type = "cs",
  ...
)
}
\arguments{
\item{n}{Number of samples}

\item{normal.cor}{Correlation parameter (n x r) or (1 x r) matrix}

\item{gamma.var}{Variance of gamma distribution (n x p or 1 x p matrix)}

\item{names}{Column name of the column vector (default "z")}

\item{type}{of correlation matrix structure (cs: compound-symmetry /
exchangable, ar: autoregressive, un: unstructured, to: toeplitz). The
dimension of \code{normal.cor} must match, i.e., for a Toeplitz correlation
matrix r = p-1, and for a cs and ar r=1.}

\item{...}{Additional arguments passed to lower level functions}
}
\value{
list of data.tables
}
\description{
Simulate from the logarithmic transform of a Gaussian copula
model with compound symmetry correlation structure and with Gamma
distributed marginals with mean one.
}
\details{
We simulate from the Gaussian copula by first drawing \eqn{X\sim
  N(0,R)} and transform the margins with \eqn{x\mapsto
  \log(F_\nu^{-1}\{\Phi(x)\})} where \eqn{\Phi} is the standard normal CDF
and \eqn{F_\nu^{-1}} is the quantile function of the Gamma distribution
with scale and rate parameter equal to \eqn{\nu}.
}
\seealso{
\link{outcome_count} \link{Trial} \link{covar_normal}
}
