% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportional_rates.R
\name{proportional_rates}
\alias{proportional_rates}
\title{Compute proportional rates}
\usage{
proportional_rates(ncan, ntot, ncan.min = 5)
}
\arguments{
\item{ncan}{integer, number of cancer of interest}

\item{ntot}{integer, overall number of cancer}

\item{ncan.min}{integer, minimum number of observation required not to mask the CI's out

Proportional incidence rates and associated 95\% confidence interval are computing assuming a Binomial distribution and the Clopper and Pearson (1934) procedure.}
}
\value{
a 3 column data.frame containing the proportional incidence rate estimate (est) and associated 95\% CI (lci, uci)
}
\description{
Compute proportional rates
}
\examples{
ncan <- c(1, 10, 100)
ntot <- c(10, 100, 1000)
proportional_rates(ncan, ntot, 5)
}
\references{
C. J. CLOPPER, B.Sc., E. S. PEARSON, D.Sc., THE USE OF CONFIDENCE OR FIDUCIAL LIMITS ILLUSTRATED IN THE CASE OF THE BINOMIAL, Biometrika, Volume 26, Issue 4, December 1934, Pages 404–413, https://doi.org/10.1093/biomet/26.4.404

Boyle P, Parkin DM. Cancer registration: principles and methods. Statistical methods for registries. IARC Sci Publ. 1991;(95):126-58. PMID: 1894318.
}
\seealso{
\code{\link[stats:binom.test]{stats::binom.test()}}
}
\concept{summary-stat}
