% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{globocan.2022.eu}
\alias{globocan.2022.eu}
\title{European countries age-specific cancer burden from GLOBOCAN 2022}
\format{
A data frame with 6,384 rows and 6 columns:
\describe{
\item{cob_iso3}{Country ISO3 code}
\item{sex}{targeted sex}
\item{ageg}{targeted age group}
\item{can}{the cancer type}
\item{ncanref}{number of cancer cases estimated in GLOBOCAN 2022}
\item{pyref}{population at risk estimated in GLOBOCAN 2022}
...
}
}
\source{
https://gco.iarc.fr/today/en
}
\usage{
globocan.2022.eu
}
\description{
A multi-columns dataset containing for all the European countries (UN definition) (as ISO3 code), sex and cancer type
combinations the number of cases and population at risk estimated in GLOBOCAN 2022. This data
are used in \code{cancerradarr} to compute the relative index on a standard reference population that
could be more easily compared between registries.
In addition to individual European countries, aggregated areas such as
E27 (European Union 27 countries) and EUN (all the UN European countries)
are stred in the dataset
}
\references{
Bray F, Laversanne M, Sung H, Ferlay J, Siegel RL, Soerjomataram I, Jemal A. Global cancer statistics 2022: GLOBOCAN estimates of incidence and mortality worldwide for 36 cancers in 185 countries. CA Cancer J Clin. 2024 May-Jun;74(3):229-263. doi: 10.3322/caac.21834. Epub 2024 Apr 4. PMID: 38572751.
}
\concept{data}
\keyword{datasets}
