% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-pkg-covr.R
\name{btw_tool_pkg_coverage}
\alias{btw_tool_pkg_coverage}
\title{Tool: Compute package test coverage}
\usage{
btw_tool_pkg_coverage(pkg = ".", filename = NULL, `_intent` = "")
}
\arguments{
\item{pkg}{Path to package directory. Defaults to \code{"."}. Must be within
current working directory.}

\item{filename}{Optional filename to filter coverage results. If \code{NULL}
(default), returns file-level summary for entire package. If provided,
returns line-level results for the specified file.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
A data frame with different structures depending on \code{filename}:
\itemize{
\item When \code{filename = NULL}: Returns file-level summary with columns
\code{filename} and \code{coverage} (percentage).
\item When \code{filename} is specified: Returns line-level details with columns
\code{filename}, \code{functions}, \code{line_start}, \code{line_end}, \code{is_covered}, and
\code{med_hits}.
}
}
\description{
Compute test coverage for an R package using \code{\link[covr:package_coverage]{covr::package_coverage()}}.
Returns either a file-level summary for the entire package or line-level
details for a specific file.
}
\seealso{
\code{\link[=btw_tools]{btw_tools()}}

Other pkg tools: 
\code{\link{btw_tool_pkg_check}()},
\code{\link{btw_tool_pkg_document}()},
\code{\link{btw_tool_pkg_test}()}
}
\concept{pkg tools}
