% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/databricks-dbi.R
\name{dbWriteTable,DatabricksConnection,character,data.frame-method}
\alias{dbWriteTable,DatabricksConnection,character,data.frame-method}
\title{Write a data frame to Databricks table}
\usage{
\S4method{dbWriteTable}{DatabricksConnection,character,data.frame}(
  conn,
  name,
  value,
  overwrite = FALSE,
  append = FALSE,
  row.names = FALSE,
  temporary = FALSE,
  field.types = NULL,
  staging_volume = NULL,
  progress = TRUE,
  ...
)
}
\arguments{
\item{conn}{A DatabricksConnection object}

\item{name}{Table name (character, Id, or SQL)}

\item{value}{Data frame to write}

\item{overwrite}{If TRUE, overwrite existing table}

\item{append}{If TRUE, append to existing table}

\item{row.names}{If TRUE, preserve row names as a column}

\item{temporary}{If TRUE, create temporary table (NOT SUPPORTED - will error)}

\item{field.types}{Named character vector of SQL types for columns}

\item{staging_volume}{Optional volume path for large dataset staging}

\item{progress}{If TRUE, show progress bar for file uploads (default: TRUE)}

\item{...}{Additional arguments}
}
\value{
TRUE invisibly on success
}
\description{
Write a data frame to Databricks table
}
