% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminals.R
\name{is_terminal}
\alias{is_terminal}
\title{Report whether locations are terminal sites or not}
\usage{
is_terminal(sim, definition = c("ND", "RW"), ...)
}
\arguments{
\item{sim}{a spatial interaction model object}

\item{definition}{terminal definition, either \code{"ND"} (for Nystuen & Dacey,
default) or \code{"RW"} (for Rihll & Wilson), see details.}

\item{...}{additional parameters}
}
\value{
a logical vector with \code{TRUE} at the positions of locations that are
terminals and \code{FALSE} for other locations.
}
\description{
This function returns a logical vector whose length equals the number of
locations. The value in position \code{i} is \code{TRUE} if location number \code{i} is
a terminal and \code{FALSE} if it is not. For the definition of terminals,
see \code{\link[=terminals]{terminals()}}.
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- rep(1, 10)
model <- blvim(distances, production, 1.3, 1 / 500, attractiveness,
  bipartite = FALSE
)
destination_names(model) <- french_cities$name[1:10]
is_terminal(model)
dist_times <- french_cities_times[1:10, 1:10]
tmodel <- blvim(dist_times, production, 1.3, 1 / 10000, attractiveness,
  bipartite = FALSE
)
destination_names(tmodel) <- french_cities$name[1:10]
is_terminal(tmodel)
}
\seealso{
\code{\link[=terminals]{terminals()}}
}
