% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin-notification.R
\name{notify_user}
\alias{notify_user}
\alias{notify_user_server}
\alias{notify_user_ui}
\title{User notification plugin module}
\usage{
notify_user(server = notify_user_server, ui = notify_user_ui)

notify_user_server(id, board, ...)

notify_user_ui(id, board)
}
\arguments{
\item{server, ui}{Server/UI for the plugin module}

\item{id}{Namespace ID}

\item{board}{Reactive values object}

\item{...}{Extra arguments passed from parent scope}
}
\value{
A plugin container inheriting from \code{notify_user} is returned by
\code{notify_user()}, while the UI component (e.g. \code{notify_user_ui()}) is
expected to return shiny UI (i.e. \code{\link[shiny:reexports]{shiny::tagList()}}; if available) and the
server component (i.e. \code{notify_user_server()}) is expected to return a
\code{\link[shiny:reactiveVal]{shiny::reactiveVal()}} or \code{\link[shiny:reactive]{shiny::reactive()}} which evaluates to a list
containing notifications per block and notification type (i.e. "message",
"warning" or "error").
}
\description{
During the evaluation cycle of each block, user notifications may be
generated to inform in case of issues such as errors or warnings. These
notifications are provided in a way that display can be controlled and
adapted to specific needs. The default \code{notify_user} plugin simply displays
notifications via \code{\link[shiny:showNotification]{shiny::showNotification()}}, with some ID management in
order to be able to clear no longer relevant notifications via
\code{\link[shiny:showNotification]{shiny::removeNotification()}}.
}
