% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-prep.R
\name{standardize_continuous_in_place}
\alias{standardize_continuous_in_place}
\title{Standardize Continuous Columns In Place}
\usage{
standardize_continuous_in_place(DT, cols, center = TRUE, scale = TRUE)
}
\arguments{
\item{DT}{A \code{data.table}. It is modified by reference.}

\item{cols}{Character vector of column names to standardize. Columns
that are not present in \code{DT} or are not numeric are silently skipped.}

\item{center}{Logical; whether to subtract the column mean.}

\item{scale}{Logical; whether to divide by the column standard deviation.}
}
\value{
The modified \code{data.table} \code{DT} (invisibly), with an
attribute \code{"standardization"} containing the means, standard
deviations, and names of the standardized columns.
}
\description{
Standardizes selected numeric columns of a data.table in place using
a z-score transformation. The function modifies \code{DT} by reference
and stores the means and standard deviations used in an attribute
called \code{"standardization"}.
}
\examples{
\donttest{
library(data.table)
DT <- data.table(x = rnorm(10), y = runif(10), z = 0:9)
standardize_continuous_in_place(DT, c("x", "y"))
attr(DT, "standardization")
}
}
