% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer-entropy.R
\name{prewhiten_count_glm}
\alias{prewhiten_count_glm}
\title{Pre-whiten count series with GLM / NegBin model}
\usage{
prewhiten_count_glm(DT, yname)
}
\arguments{
\item{DT}{A \code{data.frame} or \code{data.table} containing the
response and covariates. It must include at least:
\itemize{
\item The count variable named by \code{yname}.
\item \code{t_norm}: normalized time index.
\item \code{Regime}, \code{EconCycle}, \code{PopDensity},
\code{Epidemics}, \code{Climate}, \code{War}.
\item \code{log_exposure50}: log exposure (offset).
}}

\item{yname}{Character scalar; name of the count response column in
\code{DT}.}
}
\value{
A numeric vector of Pearson residuals (one per row in \code{DT}
used in the fit).
}
\description{
Fits a generalized linear model for count data using either a
negative binomial model with log link and offset, or a Poisson
fallback, and returns Pearson residuals to be used as a
pre-whitened series.
}
\details{
The function first attempts to fit a negative binomial GLM
via \code{MASS::glm.nb()} with a log link and \code{log_exposure50}
as an offset. If the fit fails (e.g., due to convergence issues),
it falls back to a Poisson GLM via \code{glm(family = poisson())}
with the same formula and offset.
}
\examples{
\donttest{
if (interactive()) {
  n <- 100
  DT <- data.frame(
    t_norm = seq_len(n) / n,
    I = rpois(n, 5),
    Regime = factor(sample(c("A","B"), n, TRUE)),
    EconCycle = rnorm(n), PopDensity = runif(n),
    Epidemics = rbinom(n, 1, 0.1), Climate = rnorm(n), War = rbinom(n, 1, 0.05),
    log_exposure50 = log(runif(n, 40, 60))
  )
  r_I <- prewhiten_count_glm(DT, "I")
  head(r_I)
}
}
}
