% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_biological_operations.R
\name{seq_rev_translate}
\alias{seq_rev_translate}
\title{Reverse translate amino acid sequences}
\usage{
seq_rev_translate(x, code = 1)
}
\arguments{
\item{x}{an amino acid sequence (\code{bioseq_aa})}

\item{code}{an integer indicating the genetic code to use for
reverse translation (default 1 uses the Standard genetic code). See Details.}
}
\value{
a vector of DNA sequences.
}
\description{
The function perform reverse translation of amino acid sequences.
Such operation does not exist in nature but is provided for completeness.
Because of codon degeneracy it is expected
to produce many ambiguous nucleotides.
}
\details{
Gaps (-) are interpreted as unknown amino acids (X) but can be
removed prior to the translation with the function \code{seq_remove_gap}.
}
\examples{

x <- dna("ACTTTGGCTAAG")
y <- seq_translate(x)
z <- seq_rev_translate(y)
z
# There is a loss of information during the reverse translation
all.equal(x, z)

}
\seealso{
Other biological operations: 
\code{\link{rev_complement}},
\code{\link{seq_translate}()},
\code{\link{transcription}}
}
\concept{biological operations}
