% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binspp_auxiliary.R
\name{rawMCMCoutput}
\alias{rawMCMCoutput}
\title{Obtaining the raw MCMC output}
\usage{
rawMCMCoutput(Output)
}
\arguments{
\item{Output}{list, output of the main function \code{\link[=estintp]{estintp()}}.}
}
\value{
List with named components, providing the vectors of values recorded during the run of the MCMC algorithm.
}
\description{
Access directly the raw values recorded during the run of the MCMC algorithm.
}
\details{
This function provides access to the intermediate values recorded during the run
of the MCMC algorithm. These can be used to approximate the posterior distributions
of various model parameters or construct various diagnostic plots. No burn-in period
is considered here, i.e. the function returns the values recorded during the whole
run of the Markov chain.
}
\examples{

library(spatstat)
# Prepare the dataset:
X <- trees_N4
x_left <- x_left_N4
x_right <- x_right_N4
y_bottom <- y_bottom_N4
y_top <- y_top_N4

z_beta <- list(refor = cov_refor, slope = cov_slope)
z_alpha <- list(tmi = cov_tmi, tdensity = cov_tdensity)
z_omega <- list(slope = cov_slope, reserv = cov_reserv)

# Determine the union of rectangles:
W <- owin(c(x_left[1], x_right[1]), c(y_bottom[1], y_top[1]))
if (length(x_left) >= 2) {
  for (i in 2:length(x_left)) {
    W2 <- owin(c(x_left[i], x_right[i]), c(y_bottom[i], y_top[i]))
    W <- union.owin(W, W2)
  }
}

# Dilated observation window:
W_dil <- dilation.owin(W, 100)


# Default parameters for prior distributions:
control <- list(NStep = 100, BurnIn = 20, SamplingFreq = 5)


# MCMC estimation:
Output <- estintp(X = X, control = control, x_left = x_left, x_right = x_right,
    y_bottom = y_bottom, y_top = y_top, W_dil = W_dil, z_beta = z_beta,
    z_alpha = z_alpha, z_omega = z_omega, verbose = FALSE)


# Access the raw outputs of the chain:
rawMCMCoutput(Output)

}
