% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estgtp.R
\name{estgtp}
\alias{estgtp}
\title{Auxiliary function which calculates sum values
Bayesian MCMC estimation of parameters of generalized Thomas process}
\usage{
estgtp(
  X,
  kappa0 = exp(a_kappa + ((b_kappa^2)/2)),
  omega0 = exp(a_omega + ((b_omega^2)/2)),
  lambda0 = (l_lambda + u_lambda)/2,
  theta0 = exp(a_theta + ((b_theta^2)/2)),
  skappa,
  somega,
  dlambda,
  stheta,
  smove,
  a_kappa,
  b_kappa,
  a_omega,
  b_omega,
  l_lambda,
  u_lambda,
  a_theta,
  b_theta,
  iter = 5e+05,
  plot.step = 1000,
  save.step = 1000,
  filename
)
}
\arguments{
\item{X}{A point pattern dataset (object of class \emph{ppp}) to which the model should be fitted.}

\item{kappa0}{Initial value for \emph{kappa}, by default it will be set as expectation of prior for \emph{kappa}.}

\item{omega0}{Initial value for \emph{omega}, by default it will be set as expectation of prior for \emph{omega}.}

\item{lambda0}{Initial value for \emph{lambda}, by default it will be set as expectation of prior for \emph{lambda}.}

\item{theta0}{Initial value for \emph{theta}, by default it will be set as expectation of prior for \emph{theta}.}

\item{skappa}{variability of proposal for \emph{kappa}: second parameter of log-normal distribution}

\item{somega}{variability of proposal for \emph{omega}: second parameter of log-normal distribution}

\item{dlambda}{variability of proposal for \emph{lambda}: half of range of uniform distribution}

\item{stheta}{variability of proposal for \emph{theta}: second parameter of log-normal distribution}

\item{smove}{variability of proposal for moving center point: SD of normal distribution}

\item{a_kappa}{First parameter of prior distribution for \emph{kappa}, which is log-normal distribution.}

\item{b_kappa}{Second parameter of prior distribution for \emph{kappa}, which is log-normal distribution.}

\item{a_omega}{First parameter of prior distribution for \emph{omega}, which is log-normal distribution.}

\item{b_omega}{Second parameter of prior distribution for omega, which is log-normal distribution.}

\item{l_lambda}{First parameter of prior distribution for \emph{lambda}, which is uniform distribution.}

\item{u_lambda}{Second parameter of prior distribution for \emph{lambda}, which is uniform distribution.}

\item{a_theta}{First parameter of prior distribution for \emph{theta}, which is log-normal distribution.}

\item{b_theta}{Second parameter of prior distribution for \emph{theta}, which is log-normal distribution.}

\item{iter}{Number of iterations of MCMC.}

\item{plot.step}{Step for the graph plotting. If the value is greater than \emph{iter} parameter value, no plots will be visible.}

\item{save.step}{Step for the parameters saving. The file must be specified or has to be set to larger than \emph{iter}.}

\item{filename}{The name of the output RDS file}
}
\value{
The output is an estimated MCMC chain of parameters, centers and connections.
}
\description{
Bayesian MCMC estimation of parameters of generalized
Thomas process. The cluster size is allowed to have a variance
that is greater or less than the expected value (cluster sizes are
over or under dispersed).
}
\examples{

library(spatstat)
kappa = 10
omega = .1
lambda= .5
theta = 10

X = rgtp(kappa, omega, lambda, theta, win = owin(c(0, 1), c(0, 1)))
plot(X$X)
plot(X$C)

a_kappa = 4
b_kappa = 1
x <- seq(0, 100, length = 100)
hx <- dlnorm(x, a_kappa, b_kappa)
plot(x, hx, type = "l", lty = 1, xlab = "x value",
     ylab = "Density", main = "Prior")

a_omega = -3
b_omega = 1
x <- seq(0, 1, length = 100)
hx <- dlnorm(x, a_omega, b_omega)
plot(x, hx, type = "l", lty = 1, xlab = "x value",
     ylab = "Density", main = "Prior")

l_lambda = -1
u_lambda = 0.99
x <- seq(-1, 1, length = 100)

hx <- dunif(x, l_lambda, u_lambda)
plot(x, hx, type = "l", lty = 1, xlab = "x value",
     ylab = "Density", main = "Prior")

a_theta = 4
b_theta = 1
x <- seq(0, 100, length = 100)
hx <- dlnorm(x, a_theta, b_theta)
plot(x, hx, type = "l", lty = 1, xlab = "x value",
     ylab = "Density", main = "Prior")

est = estgtp(X$X,
          skappa = exp(a_kappa + ((b_kappa ^ 2) / 2)) / 100,
          somega = exp(a_omega + ((b_omega ^ 2) / 2)) / 100,
          dlambda = 0.01,
          stheta = exp(a_theta + ((b_theta ^ 2) / 2)) / 100, smove = 0.1,
          a_kappa = a_kappa, b_kappa = b_kappa,
          a_omega = a_omega, b_omega = b_omega,
          l_lambda = l_lambda, u_lambda = u_lambda,
          a_theta = a_theta, b_theta = b_theta,
          iter = 50, plot.step = 50, save.step = 1e9,
          filename = "")

}
