% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigalgebra.R
\name{dswap}
\alias{dswap}
\title{Swap two double-precision vectors.}
\usage{
dswap(N = NULL, X, INCX = 1L, Y, INCY = 1L)
}
\arguments{
\item{N}{Number of elements in the input vectors. Defaults to the full
length of \code{X} if \code{NULL}.}

\item{X}{Double precision vector or matrix providing the first data block.}

\item{INCX}{Storage spacing between elements of \code{X}.}

\item{Y}{Double precision vector or matrix providing the second data block.}

\item{INCY}{Storage spacing between elements of \code{Y}.}
}
\value{
Invisibly returns \code{NULL}; both \code{X} and \code{Y} are
  modified in place.
}
\description{
Exchange the elements of two double precision vectors in place.
For I = 0 to N-1, swap DX(LX + I * INCX) with DY(LY + I * INCY) where LX and
LY depend on the increment signs. When an optimized BLAS is available the
implementation dispatches to \code{DSWAP}; otherwise a portable C loop
performs the exchange.
}
\details{
When an optimized BLAS is available the implementation delegates to the
Fortran \code{DSWAP} routine. Otherwise a portable C fallback performs the
exchange directly while respecting the supplied vector increments.
}
\examples{
set.seed(4670)
X <- matrix(runif(6), 3, 2)
Y <- matrix(runif(6), 3, 2)
X_original <- X
Y_original <- Y
dswap(X = X, Y = Y)
all.equal(X, Y_original)
all.equal(Y, X_original)
}
\seealso{
[dcopy()], [daxpy()] and [dscal()].
}
