% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{pls_predict_scores}
\alias{pls_predict_scores}
\title{Predict latent scores from a PLS fit}
\usage{
pls_predict_scores(object, newdata, ncomp = NULL)
}
\arguments{
\item{object}{A fitted PLS model.}

\item{newdata}{Predictor matrix for scoring.}

\item{ncomp}{Number of components to use.}
}
\value{
Matrix of component scores.
}
\description{
Predict latent scores from a PLS fit
}
\examples{
set.seed(123)
X <- matrix(rnorm(40), nrow = 10)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(10, sd = 0.1)
fit <- pls_fit(X, y, ncomp = 2, scores = "r")
pls_predict_scores(fit, X, ncomp = 2)
}
