% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kf_pls_state.R
\name{kf_pls_state_new}
\alias{kf_pls_state_new}
\title{KF-PLS streaming state (constructor)}
\usage{
kf_pls_state_new(p, m, ncomp, lambda = 0.99, q_proc = 0, r_meas = 0)
}
\arguments{
\item{p}{Integer, number of predictors (columns of \code{X}).}

\item{m}{Integer, number of responses (columns of \code{Y}).}

\item{ncomp}{Integer, number of latent components to extract at fit time.}

\item{lambda}{Numeric in (0,1], forgetting factor (closer to 1 = slower decay).}

\item{q_proc}{Non-negative numeric, process-noise magnitude (adds a ridge to
\eqn{C_{xx}} each update; useful for stabilizing ill-conditioned problems).}

\item{r_meas}{Reserved measurement-noise parameter (not used by the minimal
API yet; kept for forward compatibility).}
}
\value{
An external pointer to an internal KF-PLS state (opaque object) that
you pass to \code{\link[=kf_pls_state_update]{kf_pls_state_update()}} and then to
\code{\link[=kf_pls_state_fit]{kf_pls_state_fit()}} to produce model coefficients.
}
\description{
Create a persistent Kalman–filter PLS (KF-PLS) state that accumulates
cross-products from streaming mini-batches and later produces a
\code{big_plsr}-compatible fit via \code{\link[=kf_pls_state_fit]{kf_pls_state_fit()}}.
}
\details{
The state maintains exponentially weighted cross-moments
\eqn{C_{xx}} and \eqn{C_{xy}} with forgetting factor \code{lambda}.
When \code{lambda >= 0.999999} and \code{q_proc == 0}, the backend switches to an
\emph{exact} accumulation mode that matches concatenating all chunks (no decay).
}
\examples{
set.seed(1)
n <- 1000; p <- 50; m <- 2
X1 <- matrix(rnorm(n/2 * p), n/2, p)
X2 <- matrix(rnorm(n/2 * p), n/2, p)
B  <- matrix(rnorm(p*m), p, m)
Y1 <- scale(X1, TRUE, FALSE) \%*\% B + 0.05*matrix(rnorm(n/2*m), n/2, m)
Y2 <- scale(X2, TRUE, FALSE) \%*\% B + 0.05*matrix(rnorm(n/2*m), n/2, m)

st <- kf_pls_state_new(p, m, ncomp = 4, lambda = 0.99, q_proc = 1e-6)
kf_pls_state_update(st, X1, Y1)
kf_pls_state_update(st, X2, Y2)
fit <- kf_pls_state_fit(st)          # returns a big_plsr-compatible list
preds <- predict(bigPLSR::.finalize_pls_fit(fit, "kf_pls"), rbind(X1, X2))
head(preds)
}
\seealso{
\code{\link[=kf_pls_state_update]{kf_pls_state_update()}}, \code{\link[=kf_pls_state_fit]{kf_pls_state_fit()}}, \code{\link[=pls_fit]{pls_fit()}}
(use \code{algorithm = "kf_pls"} for the one-shot dense path).
}
