% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{external_pls_benchmarks}
\alias{external_pls_benchmarks}
\title{Benchmark results against external PLS implementations}
\format{
A data frame with 384 rows and 11 columns:
\describe{
\item{task}{Character vector identifying the task (\code{"pls1"} or \code{"pls2"}).}
\item{algorithm}{PLS algorithm used for the benchmark (e.g., \code{"simpls"}).}
\item{package}{Package providing the implementation.}
\item{median_time_s}{Median execution time in seconds.}
\item{itr_per_sec}{Iterations per second recorded by \code{bench::mark()}.}
\item{mem_alloc_bytes}{Memory usage in bytes recorded by \code{bench::mark()}.}
\item{n}{Number of observations in the simulated dataset.}
\item{p}{Number of predictors (X) in the simulated dataset.}
\item{q}{Number of responses (Y) in the simulated dataset.}
\item{ncomp}{Number of extracted components.}
\item{notes}{Helpful context on dependencies or configuration.}
}
}
\source{
Generated via \code{inst/scripts/external_pls_benchmarks.R}.
}
\usage{
data(external_pls_benchmarks)
}
\description{
Pre-computed runtime comparisons between \pkg{bigPLSR} (dense and big.memory
backends) and reference implementations from the \pkg{pls} and \pkg{mixOmics}
packages.
}
\details{
Fix \code{task = "pls1"} and select algorithms in \code{"kernelpls"},
\code{"nipals"} or \code{"simpls"} to get a full factorial design.
Fix \code{task = "pls1"} and fix \code{algorithm = "widekernelpls"} to get a
full factorial design.
Fix \code{task = "pls2"} and select algorithms in \code{"kernelpls"},
\code{"nipals"} or \code{"simpls"} to get a full factorial design.
Fix \code{task = "pls2"} and fix \code{algorithm = "widekernelpls"} to get a
full factorial design.
}
\examples{
\donttest{
data("external_pls_benchmarks", package = "bigPLSR")

sub_pls1 <- subset(external_pls_benchmarks, task == "pls1" & 
                                            algorithm != "widekernelpls")
sub_pls1$n     <- factor(sub_pls1$n)
sub_pls1$p     <- factor(sub_pls1$p)
sub_pls1$q     <- factor(sub_pls1$q)
sub_pls1$ncomp <- factor(sub_pls1$ncomp)
if (exists("replications")) replications(~ package + algorithm + task + n +
                                           p + ncomp, data = sub_pls1)

sub_pls1_wide <- subset(external_pls_benchmarks, task == "pls1" & 
                                                 algorithm == "widekernelpls")
sub_pls1_wide$n     <- factor(sub_pls1_wide$n)
sub_pls1_wide$p     <- factor(sub_pls1_wide$p)
sub_pls1_wide$q     <- factor(sub_pls1_wide$q)
sub_pls1_wide$ncomp <- factor(sub_pls1_wide$ncomp)
if (exists("replications")) replications(~ package + algorithm + task + n + 
                                           p + ncomp, data = sub_pls1_wide)

sub_pls2 <- subset(external_pls_benchmarks, task == "pls2" & 
                                            algorithm != "widekernelpls")
sub_pls2$n     <- factor(sub_pls2$n)
sub_pls2$p     <- factor(sub_pls2$p)
sub_pls2$q     <- factor(sub_pls2$q)
sub_pls2$ncomp <- factor(sub_pls2$ncomp)
if (exists("replications")) replications(~ package + algorithm + task + n + 
                                           p + ncomp, data = sub_pls2)

sub_pls2_wide <- subset(external_pls_benchmarks, task == "pls2" & 
                                                 algorithm == "widekernelpls")
sub_pls2_wide$n     <- factor(sub_pls2_wide$n)
sub_pls2_wide$p     <- factor(sub_pls2_wide$p)
sub_pls2_wide$q     <- factor(sub_pls2_wide$q)
sub_pls2_wide$ncomp <- factor(sub_pls2_wide$ncomp)
if (exists("replications")) replications(~ package + algorithm + task + n + 
                                           p + ncomp, data = sub_pls2_wide)
}
}
\keyword{datasets}
