% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_interface.R
\name{pca_supplementary_variables}
\alias{pca_supplementary_variables}
\title{Supplementary variable diagnostics}
\usage{
pca_supplementary_variables(data, scores, sdev, center = NULL)
}
\arguments{
\item{data}{Matrix-like object whose columns correspond to supplementary
variables measured on the active individuals.}

\item{scores}{Numeric matrix of component scores for the active individuals.}

\item{sdev}{Numeric vector of component standard deviations associated with
\code{scores}.}

\item{center}{Optional numeric vector specifying the centring to apply to each
supplementary variable. When \code{NULL}, column means of \code{data} are used.}
}
\value{
A list with elements \code{loadings}, \code{correlations}, \code{contributions}, and
\code{cos2}.
}
\description{
Compute loadings, correlations, contributions, and cos^2 values
for supplementary variables (columns) given component scores for the active
individuals.
}
