% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_plots.R
\name{pca_plot_biplot}
\alias{pca_plot_biplot}
\title{PCA biplot helper}
\usage{
pca_plot_biplot(
  scores,
  loadings,
  components = c(1L, 2L),
  draw = TRUE,
  draw_axes = TRUE,
  draw_arrows = TRUE,
  label_points = FALSE,
  ...
)
}
\arguments{
\item{scores}{Matrix or \code{bigmemory::big.matrix} containing principal
component scores with observations in rows and components in columns.}

\item{loadings}{Matrix or \code{bigmemory::big.matrix} of variable loadings whose
columns correspond to principal components.}

\item{components}{Integer vector of length two selecting the components to
display.}

\item{draw}{Logical; set to \code{FALSE} to return the prepared data without
plotting.}

\item{draw_axes}{Logical; when \code{TRUE}, horizontal and vertical axes are
drawn through the origin.}

\item{draw_arrows}{Logical; when \code{TRUE}, loading arrows are rendered.}

\item{label_points}{Logical; when \code{TRUE}, point labels derived from row names
are drawn next to the scores.}

\item{...}{Additional graphical parameters passed to \code{\link[graphics:plot.default]{graphics::plot()}}.}
}
\value{
A list containing the selected \code{components}, extracted \code{scores},
original \code{loadings}, scaled loadings (\code{loadings_scaled}), and the applied
\code{scale_factor}. The list is returned invisibly. When \code{draw = TRUE}, a biplot
is produced using base graphics.
}
\description{
Combines principal component scores and variable loadings in a single
scatter plot. The helper accepts both standard matrices and
\code{bigmemory::big.matrix} inputs, extracting only the requested component
columns. When \code{draw = TRUE}, the function scales the loadings to match the
score ranges, draws optional axes, overlays loading arrows, and labels
observations when requested.
}
